/****** Object:  Table [dbo].[XTaskCategory]    Script Date: 11/08/2015 08:21:05 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[XTaskCategory](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](40) COLLATE Hungarian_CI_AS NOT NULL,
 CONSTRAINT [pXTaskCategory] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]





/****** Object:  Table [dbo].[XTaskFile]    Script Date: 11/08/2015 08:22:00 ******/
CREATE TABLE [dbo].[XTaskFile](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AvatarId] [int] NULL,
	[Name] [nvarchar](80) COLLATE Hungarian_CI_AS NOT NULL,
	[IsArchive] [bit] NOT NULL CONSTRAINT [DF_XTaskFile_IsArchive]  DEFAULT ((0)),
	[CurrentCounter] [int] NOT NULL,
	[VoucherSign] [nvarchar](5) COLLATE Hungarian_CI_AS NOT NULL,
	[IsGeneretadVoucher] [bit] NOT NULL CONSTRAINT [DF_XTaskFile_IsGeneretadVoucher]  DEFAULT ((0)),
	[ExtraDataCategoryId] [int] NULL,
 CONSTRAINT [pXTaskFile] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[XTaskFile]  WITH CHECK ADD  CONSTRAINT [fXTaskFile_Avatar] FOREIGN KEY([AvatarId])
REFERENCES [dbo].[Avatar] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[XTaskFile] CHECK CONSTRAINT [fXTaskFile_Avatar]




/****** Object:  Table [dbo].[XTask]    Script Date: 11/08/2015 08:22:58 ******/
CREATE TABLE [dbo].[XTask](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[timestamp] [timestamp] NOT NULL,
	[AvatarId] [int] NULL,
	[TaskFileId] [int] NOT NULL,
	[PartnerId] [int] NULL,
	[OrdinalNumber] [int] NULL,
	[VoucherNum] [nvarchar](32) COLLATE Hungarian_CI_AS NULL,
	[VoucherDate] [datetime] NOT NULL,
	[TypeId] [int] NOT NULL,
	[Name] [nvarchar](80) COLLATE Hungarian_CI_AS NOT NULL,
	[CalendarName] [nvarchar](20) COLLATE Hungarian_CI_AS NOT NULL,
	[PlanedDeadline] [datetime] NOT NULL,
	[Note] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
	[ProcessStatus] [int] NOT NULL,
	[ResponsibleUserId] [int] NOT NULL,
	[ProjectId] [int] NULL,
 CONSTRAINT [pXTask] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[XTask]  WITH CHECK ADD  CONSTRAINT [fXTask_Avatar] FOREIGN KEY([AvatarId])
REFERENCES [dbo].[Avatar] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[XTask] CHECK CONSTRAINT [fXTask_Avatar]

ALTER TABLE [dbo].[XTask]  WITH CHECK ADD  CONSTRAINT [fXTask_ContoUser] FOREIGN KEY([ResponsibleUserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[XTask] CHECK CONSTRAINT [fXTask_ContoUser]

ALTER TABLE [dbo].[XTask]  WITH CHECK ADD  CONSTRAINT [fXTask_Partner] FOREIGN KEY([PartnerId])
REFERENCES [dbo].[Partner] ([Id])
ALTER TABLE [dbo].[XTask] CHECK CONSTRAINT [fXTask_Partner]

ALTER TABLE [dbo].[XTask]  WITH CHECK ADD  CONSTRAINT [fXTask_XTaskFile] FOREIGN KEY([TaskFileId])
REFERENCES [dbo].[XTaskFile] ([Id])
ALTER TABLE [dbo].[XTask] CHECK CONSTRAINT [fXTask_XTaskFile]




/****** Object:  Table [dbo].[XTaskTodo]    Script Date: 11/08/2015 08:24:50 ******/
CREATE TABLE [dbo].[XTaskTodo](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[TaskId] [int] NOT NULL,
	[StartDateTime] [datetime] NOT NULL,
	[EndDateTime] [datetime] NULL,
	[Description] [nvarchar](128) COLLATE Hungarian_CI_AS NOT NULL,
	[Note] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
	[ResponsibleUserId] [int] NOT NULL,
	[IsClosed] [bit] NOT NULL CONSTRAINT [DF_XTaskTodo_IsClosed]  DEFAULT ((0)),
	[ItemColor] [int] NOT NULL DEFAULT ((0)),
 CONSTRAINT [pXTaskTodo] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[XTaskTodo]  WITH CHECK ADD  CONSTRAINT [fXTaskTodoContoUser] FOREIGN KEY([ResponsibleUserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[XTaskTodo] CHECK CONSTRAINT [fXTaskTodoContoUser]

ALTER TABLE [dbo].[XTaskTodo]  WITH CHECK ADD  CONSTRAINT [fXTaskTodoXTask] FOREIGN KEY([TaskId])
REFERENCES [dbo].[XTask] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[XTaskTodo] CHECK CONSTRAINT [fXTaskTodoXTask]



/****** Object:  Table [dbo].[XTaskTodoItem]    Script Date: 01/15/2016 16:47:46 ******/
CREATE TABLE [dbo].[XTaskTodoItem](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[TaskTodoId] [int] NULL,
	[StartDateTime] [datetime] NOT NULL,
	[EndDateTime] [datetime] NULL,
	[Note] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
	[Period] [decimal](18, 2) NULL,
	[BackGroundColor] [int] NULL,
	[IdleTypeId] [int] NULL,
	[Identifier] [uniqueidentifier] NULL,
	[UserId] [int] NOT NULL,
 CONSTRAINT [pXTaskTodoItem] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[XTaskTodoItem]  WITH CHECK ADD  CONSTRAINT [fXTaskTodoItemContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[XTaskTodoItem] CHECK CONSTRAINT [fXTaskTodoItemContoUser]

ALTER TABLE [dbo].[XTaskTodoItem]  WITH CHECK ADD  CONSTRAINT [fXTaskTodoItemXTaskTodo] FOREIGN KEY([TaskTodoId])
REFERENCES [dbo].[XTaskTodo] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[XTaskTodoItem] CHECK CONSTRAINT [fXTaskTodoItemXTaskTodo]




/****** Object:  Table [dbo].[XTaskToTask]    Script Date: 11/08/2015 08:26:48 ******/
CREATE TABLE [dbo].[XTaskToTask](
	[FromTaskId] [int] NOT NULL,
	[ToTaskId] [int] NOT NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[XTaskToTask]  WITH CHECK ADD  CONSTRAINT [fXTaskToTask_XTask] FOREIGN KEY([FromTaskId])
REFERENCES [dbo].[XTask] ([Id])
ALTER TABLE [dbo].[XTaskToTask] CHECK CONSTRAINT [fXTaskToTask_XTask]

ALTER TABLE [dbo].[XTaskToTask]  WITH CHECK ADD  CONSTRAINT [fXTaskToTask_XTask_2] FOREIGN KEY([ToTaskId])
REFERENCES [dbo].[XTask] ([Id])
ALTER TABLE [dbo].[XTaskToTask] CHECK CONSTRAINT [fXTaskToTask_XTask_2]





/****** Object:  Table [dbo].[XTaskBlog]    Script Date: 11/08/2015 08:27:29 ******/
CREATE TABLE [dbo].[XTaskBlog](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[TaskId] [int] NOT NULL,
	[BlogText] [nvarchar](max) COLLATE Hungarian_CI_AS NOT NULL,
	[BlogRft] [nvarchar](max) COLLATE Hungarian_CI_AS NOT NULL,
	[UserId] [int] NOT NULL,
 CONSTRAINT [PK_XTaskBlog] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[XTaskBlog]  WITH CHECK ADD  CONSTRAINT [fXTaskBlog_ContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[XTaskBlog] CHECK CONSTRAINT [fXTaskBlog_ContoUser]

ALTER TABLE [dbo].[XTaskBlog]  WITH CHECK ADD  CONSTRAINT [fXTaskBlog_XTask] FOREIGN KEY([TaskId])
REFERENCES [dbo].[XTask] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[XTaskBlog] CHECK CONSTRAINT [fXTaskBlog_XTask]




/****** Object:  Table [dbo].[XTaskLog]    Script Date: 11/08/2015 08:32:53 ******/
CREATE TABLE [dbo].[XTaskLog](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[TaskId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[LogDate] [datetime] NOT NULL,
	[LogText] [nvarchar](max) COLLATE Hungarian_CI_AS NOT NULL,
 CONSTRAINT [PK_XTaskLog] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[XTaskLog]  WITH CHECK ADD  CONSTRAINT [fXTaskLogContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[XTaskLog] CHECK CONSTRAINT [fXTaskLogContoUser]

ALTER TABLE [dbo].[XTaskLog]  WITH CHECK ADD  CONSTRAINT [fXTaskLogXTask] FOREIGN KEY([TaskId])
REFERENCES [dbo].[XTask] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[XTaskLog] CHECK CONSTRAINT [fXTaskLogXTask]




/****** Object:  Table [dbo].[XTaskUser]    Script Date: 11/08/2015 08:49:27 ******/
CREATE TABLE [dbo].[XTaskUser](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[TaskId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[RightTypeId] [int] NOT NULL,
	[CalendarColor] [int] NULL,
 CONSTRAINT [PK_XTaskUser] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[XTaskUser]  WITH CHECK ADD  CONSTRAINT [fXTaskUser_ContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[XTaskUser] CHECK CONSTRAINT [fXTaskUser_ContoUser]

ALTER TABLE [dbo].[XTaskUser]  WITH CHECK ADD  CONSTRAINT [fXTaskUser_XTask] FOREIGN KEY([TaskId])
REFERENCES [dbo].[XTask] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[XTaskUser] CHECK CONSTRAINT [fXTaskUser_XTask]




/****** Object:  Table [dbo].[XTaskEvent]    Script Date: 11/08/2015 08:52:06 ******/
CREATE TABLE [dbo].[XTaskEvent](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[TaskId] [int] NOT NULL,
	[EventTypeId] [int] NOT NULL,
	[Description] [nvarchar](max) COLLATE Hungarian_CI_AS NOT NULL,
	[EventDate] [datetime] NOT NULL,
	[IsGenerated] [bit] NOT NULL CONSTRAINT [DF_XTaskEvent_IsGenerated]  DEFAULT ((0)),
	[UserId] [int] NULL,
 CONSTRAINT [PK_XTaskEvent] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[XTaskEvent]  WITH CHECK ADD  CONSTRAINT [fXTaskEvent_XTask] FOREIGN KEY([TaskId])
REFERENCES [dbo].[XTask] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[XTaskEvent] CHECK CONSTRAINT [fXTaskEvent_XTask]

ALTER TABLE [dbo].[XTaskEvent]  WITH CHECK ADD  CONSTRAINT [fXTaskEventContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[XTaskEvent] CHECK CONSTRAINT [fXTaskEventContoUser]



/****** Object:  Table [dbo].[XTaskCategoryXTask]    Script Date: 11/08/2015 08:52:55 ******/
CREATE TABLE [dbo].[XTaskCategoryXTask](
	[TaskId] [int] NOT NULL,
	[TaskCategoryId] [int] NOT NULL
) ON [PRIMARY]

ALTER TABLE [dbo].[XTaskCategoryXTask]  WITH CHECK ADD  CONSTRAINT [fXTaskCategoryXTask_XTask] FOREIGN KEY([TaskId])
REFERENCES [dbo].[XTask] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[XTaskCategoryXTask] CHECK CONSTRAINT [fXTaskCategoryXTask_XTask]

ALTER TABLE [dbo].[XTaskCategoryXTask]  WITH CHECK ADD  CONSTRAINT [fXTaskCategoryXTask_XTaskCategory] FOREIGN KEY([TaskCategoryId])
REFERENCES [dbo].[XTaskCategory] ([Id])
ALTER TABLE [dbo].[XTaskCategoryXTask] CHECK CONSTRAINT [fXTaskCategoryXTask_XTaskCategory]




/****** Object:  Table [dbo].[TableType]    Script Date: 05/01/2014 09:55:40 ******/
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (650, 'XTask', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (651, 'XTaskBlog', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (652, 'XTaskLog', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (653, 'XTaskCategory', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (654, 'XTaskCategoryXTask', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (655, 'XTaskEvent', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (656, 'XTaskFile', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (657, 'XTaskTodo', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (658, 'XTaskTodoItem', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (659, 'XTaskToTask', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (660, 'XTaskUser', 0, 0)




/****** Szerzds belltsok funkcitr felvtele ******/
INSERT INTO [dbo].[FuncSpace] ([Name], Description, Allowed, TypeId) VALUES ('Clicxoft.Task.Settings', 'Feladatkezel program belltsok', 'True', 1)
INSERT INTO [dbo].[FuncSpace] ([Name], Description, Allowed, TypeId) VALUES ('Clicxoft.Task.Datamining', 'Feladatkezel adatbnyszat', 'True', 1)



/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 01/04/2015 21:26:52 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ClicxoftDatabaseRevison]') AND type in (N'U'))
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	CREATE TABLE [dbo].[ClicxoftDatabaseRevison](
		[Revision] [int] NOT NULL,
		[ProductId] [int] NOT NULL,
		[Performed] [datetime] NOT NULL,
	 CONSTRAINT [pClicxoftDatabaseRevison] PRIMARY KEY CLUSTERED 
	(
		[Revision] ASC,
		[ProductId] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1000, 'ClicxoftDatabaseRevison', 0, 0)
END

IF (SELECT [Revision] FROM [ClicxoftDatabaseRevison] WHERE [ProductId] = 10) IS NULL
BEGIN
	INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (1001, 10, '2015.10.01')
END