      CREATE TRIGGER [dbo].[OnUpdateServiceWorksheetFile]
      ON [dbo].[ServiceWorksheetFile]
      FOR UPDATE AS
      BEGIN
      -- =============================================
      -- Author:		Bokor J. Mrk
      -- Adapted:		dr. Dzsa Andrs
      -- Create date: 2014.08.06
      -- Description:	General insert trigger
      --              to assign avatarId
      -- =============================================
      SET NOCOUNT ON
      --work wariables
      DECLARE @ServiceWorksheetFilesId Int
      DECLARE @NewAvatarID Int
      --Table Type Detection
      DECLARE @TriggeredTableId Int
      --DataSpace fill variables
      DECLARE @ServiceWorksheetFilesName nvarchar(50)
      DECLARE @DataSpaceName nvarchar(256)
      DECLARE @DataSpaceDescription nvarchar(80)

      --query our trigger's id
      SELECT @TriggeredTableId = Id FROM TableType WHERE Name = 'ServiceWorksheetFile'

      DECLARE tmpCursor CURSOR LOCAL FOR
      SELECT Inserted.Id, Inserted.AvatarId, Inserted.Name
      FROM Inserted INNER JOIN Deleted ON Inserted.Id = Deleted.Id
      OPEN tmpCursor
      FETCH NEXT FROM tmpCursor INTO @ServiceWorksheetFilesId, @NewAvatarID, @ServiceWorksheetFilesName
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
      --Insert DataSpace Entry
      SET @DataSpaceName = CAST(@TriggeredTableId as varchar) + '.' + CAST(@ServiceWorksheetFilesId as varchar)
      SET @DataSpaceDescription =  'Szervz munkalap llomny:' + @ServiceWorksheetFilesName
      EXEC sp_SaveToDataSpace @NewAvatarID, @DataSpaceName, @DataSpaceDescription, 2
      -- get next record
      FETCH NEXT FROM tmpCursor INTO @ServiceWorksheetFilesId, @NewAvatarID, @ServiceWorksheetFilesName
      END
      CLOSE tmpCursor
      DEALLOCATE tmpCursor
      END