﻿IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[InvoiceAddressXml]') AND type in (N'U'))
BEGIN
	/****** Object:  Table [dbo].[InvoiceAddressXml]    Script Date: 12/30/2015 10:16:48 ******/	
	CREATE TABLE [dbo].[InvoiceAddressXml](
		[Id] [int] IDENTITY(1,1) NOT NULL,
		[InvoiceId] [int] NOT NULL,
		[Name] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
		[VATNumber] [nvarchar](32) COLLATE Hungarian_CI_AS NULL,
		[VATNumberEU] [nvarchar](32) COLLATE Hungarian_CI_AS NULL,
		[Zip] [nvarchar](10) COLLATE Hungarian_CI_AS NULL,
		[City] [nvarchar](50) COLLATE Hungarian_CI_AS NULL,
		[District] [nvarchar](6) COLLATE Hungarian_CI_AS NULL,
		[PublicSpace] [nvarchar](50) COLLATE Hungarian_CI_AS NULL,
		[PublicSpaceType] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[HouseNr] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[Building] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[Staircase] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[Floor] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[Door] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[IsKATA] [bit] NOT NULL CONSTRAINT [DF_InvoiceAddressXml_IsKATA]  DEFAULT ((0)),
		[IsSoloTrader] [bit] NOT NULL CONSTRAINT [DF_InvoiceAddressXml_IsSoloTrader]  DEFAULT ((0)),
		[SoloTraderNum] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[IsSuuplier] [bit] NOT NULL CONSTRAINT [DF_InvoiceAddressXml_IsSuuplier]  DEFAULT ((0)),
	 CONSTRAINT [pInvoiceAddressXml] PRIMARY KEY CLUSTERED 
	(
		[Id] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[InvoiceAddressXml]  WITH CHECK ADD  CONSTRAINT [fInvoiceAddressXmlInvoice] FOREIGN KEY([InvoiceId])
	REFERENCES [dbo].[Invoice] ([Id])
	ON DELETE CASCADE
	ALTER TABLE [dbo].[InvoiceAddressXml] CHECK CONSTRAINT [fInvoiceAddressXmlInvoice]				

	/****** Object:  Table [dbo].[FirmAddressXml]    Script Date: 11/19/2015 17:57:43 ******/
	CREATE TABLE [dbo].[FirmAddressXml](
		[id] [int] IDENTITY(1,1) NOT NULL,
		[DivisionId] [int] NOT NULL,
		[District] [nvarchar](6) COLLATE Hungarian_CI_AS NULL,
		[PublicSpace] [nvarchar](50) COLLATE Hungarian_CI_AS NULL,
		[PublicSpaceType] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[HouseNr] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[Building] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[Staircase] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[Floor] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[Door] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[IsKATA] [bit] NOT NULL CONSTRAINT [DF_FirmAddressXml_kisadozo]  DEFAULT ((0)),
		[IsValid] [bit] NOT NULL CONSTRAINT [DF_FirmAddressXml_IsValid]  DEFAULT ((1)),
		[IsSoloTrader] [bit] NOT NULL CONSTRAINT [DF_FirmAddressXml_IsSoloTrader]  DEFAULT ((0)),
		[SoloTraderNum] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
	 CONSTRAINT [pFirmAddressXml] PRIMARY KEY CLUSTERED 
	(
		[id] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[FirmAddressXml]  WITH CHECK ADD  CONSTRAINT [fFirmAddressXmlDivision] FOREIGN KEY([DivisionId])
	REFERENCES [dbo].[Division] ([Id])
	ALTER TABLE [dbo].[FirmAddressXml] CHECK CONSTRAINT [fFirmAddressXmlDivision]

	/****** Object:  Table [dbo].[PartnerAddressXml]    Script Date: 12/30/2015 09:47:28 ******/
	CREATE TABLE [dbo].[PartnerAddressXml](
		[Id] [int] IDENTITY(1,1) NOT NULL,
		[PartnerId] [int] NOT NULL,
		[Zip] [nvarchar](10) COLLATE Hungarian_CI_AS NOT NULL,
		[City] [nvarchar](50) COLLATE Hungarian_CI_AS NOT NULL,
		[District] [nvarchar](6) COLLATE Hungarian_CI_AS NULL,
		[PublicSpace] [nvarchar](50) COLLATE Hungarian_CI_AS NOT NULL,
		[PublicSpaceType] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[HouseNr] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[Building] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[Staircase] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[Floor] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
		[Door] [nvarchar](20) COLLATE Hungarian_CI_AS NULL,
	 CONSTRAINT [pPartnerAddressXml] PRIMARY KEY CLUSTERED 
	(
		[Id] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[PartnerAddressXml]  WITH CHECK ADD  CONSTRAINT [FK_PartnerAddressXml_Partner] FOREIGN KEY([PartnerId])
	REFERENCES [dbo].[Partner] ([Id])
	ON DELETE CASCADE
	ALTER TABLE [dbo].[PartnerAddressXml] CHECK CONSTRAINT [FK_PartnerAddressXml_Partner]

	/****** Object:  Table [dbo].[SystemDefault]    Script Date: 05/01/2014 09:55:40 ******/
	INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (941, 'FirmAddressXml', 0, 0)
	INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (942, 'InvoiceAddressXml', 0, 0)
	INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (943, 'PartnerAddressXml', 0, 0)
END	




/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 01/04/2015 21:26:52 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ClicxoftDatabaseRevison]') AND type in (N'U'))
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	CREATE TABLE [dbo].[ClicxoftDatabaseRevison](
		[Revision] [int] NOT NULL,
		[ProductId] [int] NOT NULL,
		[Performed] [datetime] NOT NULL,
	 CONSTRAINT [pClicxoftDatabaseRevison] PRIMARY KEY CLUSTERED 
	(
		[Revision] ASC,
		[ProductId] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1000, 'ClicxoftDatabaseRevison', 0, 0)
END

IF (SELECT [Revision] FROM [ClicxoftDatabaseRevison] WHERE [Revision] = 102) IS NULL
BEGIN
	INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (102, 1, '2016.01.01')
END

IF (SELECT [Revision] FROM [ClicxoftDatabaseRevison] WHERE [Revision] = 402) IS NULL
BEGIN
	INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (402, 4, '2016.01.01')
END
