CREATE TRIGGER [dbo].[OnUpdateSalesFile]
ON [dbo].[SalesFile]
FOR UPDATE AS
BEGIN
SET NOCOUNT ON
--work wariables
DECLARE @SalesFileId Int
DECLARE @NewAvatarID Int
--Table Type Detection
DECLARE @TriggeredTableId Int
DECLARE @TaxYearNum int
--DataSpace fill variables
DECLARE @SalesFileName nvarchar(50)
DECLARE @DataSpaceName nvarchar(256)
DECLARE @DataSpaceDescription nvarchar(80)

--query our trigger's id
SELECT @TriggeredTableId = Id FROM TableType WHERE Name = 'SalesFile'

DECLARE tmpCursor CURSOR LOCAL FOR
SELECT Inserted.Id, Inserted.AvatarId, Inserted.Name
FROM Inserted ORDER BY Inserted.Id
OPEN tmpCursor
FETCH NEXT FROM tmpCursor INTO @SalesFileId, @NewAvatarID, @SalesFileName
WHILE (@@FETCH_STATUS = 0)
BEGIN
--Insert DataSpace Entry
SET @DataSpaceName = CAST(@TriggeredTableId as varchar) + '.' + CAST(@SalesFileId as varchar)
SET @DataSpaceDescription =  ':rtkests gylet llomny:' + @SalesFileName
EXEC sp_SaveToDataSpace @NewAvatarID, @DataSpaceName, @DataSpaceDescription, 2
-- get next record
FETCH NEXT FROM tmpCursor INTO @SalesFileId, @NewAvatarID, @SalesFileName
END
CLOSE tmpCursor
DEALLOCATE tmpCursor
END