﻿/****** Object:  Table [dbo].[SalesCategory]    Script Date: 10/19/2016 13:02:20 ******/
CREATE TABLE [dbo].[SalesCategory](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_SalesCategory] PRIMARY KEY CLUSTERED 
( [Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[SalesFile]    Script Date: 10/19/2016 13:02:49 ******/
CREATE TABLE [dbo].[SalesFile](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AvatarId] [int] NULL,
	[Name] [nvarchar](50) NOT NULL,
	[CurrentCounter] [int] NOT NULL,
	[YearNum] [nvarchar](4) NOT NULL,
	[VoucherSign] [nvarchar](5) NOT NULL,
	[Digits] [int] NOT NULL,
	[IsArchive] [bit] NOT NULL,
 CONSTRAINT [PK_SalesFile] PRIMARY KEY CLUSTERED 
([Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[SalesFile]  WITH CHECK ADD  CONSTRAINT [FK_SalesFile_Avatar] FOREIGN KEY([AvatarId])
REFERENCES [dbo].[Avatar] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[SalesFile] CHECK CONSTRAINT [FK_SalesFile_Avatar]
ALTER TABLE [dbo].[SalesFile] ADD  CONSTRAINT [DF_SalesFile_IsArchive]  DEFAULT ((0)) FOR [IsArchive]



/****** Object:  Table [dbo].[Sales]    Script Date: 10/19/2016 13:03:20 ******/
CREATE TABLE [dbo].[Sales](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AvatarId] [int] NULL,
	[SalesFileId] [int] NOT NULL,
	[PartnerId] [int] NOT NULL,
	[ContactId] [int] NULL,
	[Subject] [nvarchar](80) NOT NULL,
	[Date] [datetime] NOT NULL,
	[Description] [nvarchar](max) NULL,
	[StatusId] [int] NOT NULL,
	[InitiatedId] [int] NOT NULL,
	[OrdinalNumber] [int] NOT NULL,
	[VoucherNum] [nvarchar](20) NOT NULL,
	[Value] [decimal](18, 2) NULL,
	[ContactName] [nvarchar](50) NULL,
	[Email] [nvarchar](50) NULL,
	[Phone] [nvarchar](50) NULL,
	[SalesUserId] [int] NULL,
	[ClosingVoucher] [nvarchar](20) NULL,
	[ClosingDocument] [nvarchar](80) NULL,
 CONSTRAINT [PK_Sales] PRIMARY KEY CLUSTERED 
([Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
ALTER TABLE [dbo].[Sales]  WITH CHECK ADD  CONSTRAINT [FK_Sales_Avatar] FOREIGN KEY([AvatarId])
REFERENCES [dbo].[Avatar] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[Sales] CHECK CONSTRAINT [FK_Sales_Avatar]
ALTER TABLE [dbo].[Sales]  WITH CHECK ADD  CONSTRAINT [FK_Sales_Contact] FOREIGN KEY([ContactId])
REFERENCES [dbo].[Contact] ([Id])
ALTER TABLE [dbo].[Sales] CHECK CONSTRAINT [FK_Sales_Contact]
ALTER TABLE [dbo].[Sales]  WITH CHECK ADD  CONSTRAINT [FK_Sales_ContoUser] FOREIGN KEY([SalesUserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[Sales] CHECK CONSTRAINT [FK_Sales_ContoUser]
ALTER TABLE [dbo].[Sales]  WITH CHECK ADD  CONSTRAINT [FK_Sales_Partner] FOREIGN KEY([PartnerId])
REFERENCES [dbo].[Partner] ([Id])
ALTER TABLE [dbo].[Sales] CHECK CONSTRAINT [FK_Sales_Partner]
ALTER TABLE [dbo].[Sales]  WITH CHECK ADD  CONSTRAINT [FK_Sales_SalesFile] FOREIGN KEY([SalesFileId])
REFERENCES [dbo].[SalesFile] ([Id])
ALTER TABLE [dbo].[Sales] CHECK CONSTRAINT [FK_Sales_SalesFile]



/****** Object:  Table [dbo].[SalesEvent]    Script Date: 10/19/2016 12:59:41 ******/
CREATE TABLE [dbo].[SalesEvent](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SalesId] [int] NOT NULL,
	[SalesCategoryId] [int] NOT NULL,
	[Name] [nvarchar](80) NOT NULL,
	[Date] [datetime] NOT NULL,
	[Description] [nvarchar](max) NULL,
	[IsGenerated] [bit] NOT NULL,
	[UserId] [int] NOT NULL,
 CONSTRAINT [PK_SalesEvent] PRIMARY KEY CLUSTERED 
([Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

ALTER TABLE [dbo].[SalesEvent]  WITH CHECK ADD  CONSTRAINT [FK_SalesEvent_ContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[SalesEvent] CHECK CONSTRAINT [FK_SalesEvent_ContoUser]
ALTER TABLE [dbo].[SalesEvent]  WITH CHECK ADD  CONSTRAINT [FK_SalesEvent_Sales] FOREIGN KEY([SalesId])
REFERENCES [dbo].[Sales] ([Id])

ALTER TABLE [dbo].[SalesEvent] CHECK CONSTRAINT [FK_SalesEvent_Sales]
ALTER TABLE [dbo].[SalesEvent]  WITH CHECK ADD  CONSTRAINT [FK_SalesEvent_SalesCategory] FOREIGN KEY([SalesCategoryId])
REFERENCES [dbo].[SalesCategory] ([Id])
ALTER TABLE [dbo].[SalesEvent] CHECK CONSTRAINT [FK_SalesEvent_SalesCategory]
ALTER TABLE [dbo].[SalesEvent] ADD  CONSTRAINT [DF_SalesEvent_IsGenerated]  DEFAULT ((0)) FOR [IsGenerated]




/****** Object:  Table [dbo].[SalesTodo]    Script Date: 10/19/2016 13:00:42 ******/
CREATE TABLE [dbo].[SalesTodo](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SalesId] [int] NOT NULL,
	[Date] [datetime] NOT NULL,
	[Name] [nvarchar](80) NOT NULL,
	[Deadline] [datetime] NOT NULL,
	[IsClosed] [bit] NOT NULL,
	[Note] [varchar](max) NULL,
	[UserId] [int] NOT NULL,
 CONSTRAINT [PK_SalesTodo] PRIMARY KEY CLUSTERED 
([Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
SET ANSI_PADDING OFF
ALTER TABLE [dbo].[SalesTodo]  WITH CHECK ADD  CONSTRAINT [FK_SalesTodo_ContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[SalesTodo] CHECK CONSTRAINT [FK_SalesTodo_ContoUser]
ALTER TABLE [dbo].[SalesTodo]  WITH CHECK ADD  CONSTRAINT [FK_SalesTodo_Sales] FOREIGN KEY([SalesId])
REFERENCES [dbo].[Sales] ([Id])
ALTER TABLE [dbo].[SalesTodo] CHECK CONSTRAINT [FK_SalesTodo_Sales]
ALTER TABLE [dbo].[SalesTodo] ADD  CONSTRAINT [DF_SalesTodo_IsClosed]  DEFAULT ((0)) FOR [IsClosed]



/****** Object:  Table [dbo].[SalesStatus]    Script Date: 10/20/2016 08:48:11 ******/
CREATE TABLE [dbo].[SalesStatus](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SalesId] [int] NOT NULL,
	[StatusId] [int] NOT NULL,
	[ChangeDate] [datetime] NOT NULL,
	[FormerStatusId] [int] NOT NULL,
 CONSTRAINT [PK_SalesStatus] PRIMARY KEY CLUSTERED 
([Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[SalesStatus]  WITH CHECK ADD  CONSTRAINT [FK_SalesStatus_Sales] FOREIGN KEY([SalesId])
REFERENCES [dbo].[Sales] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[SalesStatus] CHECK CONSTRAINT [FK_SalesStatus_Sales]




/****** Object:  Table [dbo].[TableType]    Script Date: 08/04/2014 09:55:40 ******/
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (530, 'Sales', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (531, 'SalesFile', 1, 0)




/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 01/04/2015 21:26:52 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ClicxoftDatabaseRevison]') AND type in (N'U'))
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	CREATE TABLE [dbo].[ClicxoftDatabaseRevison](
		[Revision] [int] NOT NULL,
		[ProductId] [int] NOT NULL,
		[Performed] [datetime] NOT NULL,
	 CONSTRAINT [pClicxoftDatabaseRevison] PRIMARY KEY CLUSTERED 
	(
		[Revision] ASC,
		[ProductId] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1000, 'ClicxoftDatabaseRevison', 0, 0)
END

IF (SELECT [Revision] FROM [ClicxoftDatabaseRevison] WHERE [ProductId] = 19) IS NULL
BEGIN
	INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (1901, 19, '2016.10.01')
END
