/****** Object:  Table [dbo].[Sms]    Script Date: 04/18/2015 13:06:19 ******/
CREATE TABLE [dbo].[Sms](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[TypeId] [int] NOT NULL,
	[DueDate] [datetime] NOT NULL,
	[ContoUserId] [int] NULL,
	[SrcAvatarId] [int] NULL,
	[Body] [nvarchar](max) COLLATE Hungarian_CI_AS NOT NULL,
	[PhoneNumber] [nvarchar](16) COLLATE Hungarian_CI_AS NOT NULL,
	[SentDate] [datetime] NULL,
	[ErrorLog] [varchar](max) COLLATE Hungarian_CI_AS NULL,
	[ContactId] [int] NULL,
	[ContactName] [nvarchar](50) COLLATE Hungarian_CI_AS NULL,
	[PartnerId] [int] NULL,
 CONSTRAINT [pSms] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

SET ANSI_PADDING OFF




/****** Object:  Table [dbo].[SmsContactCategory]    Script Date: 04/18/2015 13:07:11 ******/
CREATE TABLE [dbo].[SmsContactCategory](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](80) COLLATE Hungarian_CI_AS NOT NULL,
 CONSTRAINT [pSmsContactCategory] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]




/****** Object:  Table [dbo].[SmsPhoneBook]    Script Date: 04/18/2015 13:07:51 ******/
CREATE TABLE [dbo].[SmsPhoneBook](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ForName] [nvarchar](50) COLLATE Hungarian_CI_AS NOT NULL,
	[LastName] [nvarchar](50) COLLATE Hungarian_CI_AS NULL,
	[Note] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
	[Address] [nvarchar](128) COLLATE Hungarian_CI_AS NULL,
	[SmsContactCategoryId] [int] NULL,
 CONSTRAINT [psmsPhoneBook] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[SmsPhoneBook]  WITH CHECK ADD  CONSTRAINT [fSmsPhoneBookSmsContactCategory] FOREIGN KEY([SmsContactCategoryId])
REFERENCES [dbo].[SmsContactCategory] ([Id])
ALTER TABLE [dbo].[SmsPhoneBook] CHECK CONSTRAINT [fSmsPhoneBookSmsContactCategory]




/****** Object:  Table [dbo].[SmsPhoneBookValue]    Script Date: 04/18/2015 13:08:46 ******/
CREATE TABLE [dbo].[SmsPhoneBookValue](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SmsPhoneBookId] [int] NOT NULL,
	[Value] [nvarchar](32) COLLATE Hungarian_CI_AS NOT NULL,
 CONSTRAINT [pSmsPhoneBookValue] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[SmsPhoneBookValue]  WITH CHECK ADD  CONSTRAINT [fSmsPhoneBookValueSmsPhoneBook] FOREIGN KEY([SmsPhoneBookId])
REFERENCES [dbo].[SmsPhoneBook] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[SmsPhoneBookValue] CHECK CONSTRAINT [fSmsPhoneBookValueSmsPhoneBook]




/****** Object:  Table [dbo].[SmsRelation]    Script Date: 04/19/2015 08:38:59 ******/
CREATE TABLE [dbo].[SmsRelation](
	[SmsId] [int] NOT NULL,
	[RelatedId] [int] NOT NULL,
	[TableId] [int] NOT NULL,
 CONSTRAINT [pSmsRelation] PRIMARY KEY CLUSTERED 
(
	[SmsId] ASC,
	[RelatedId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]





/****** Object:  Table [dbo].[EmailContactCategory]    Script Date: 10/01/2015 09:10:09 ******/
CREATE TABLE [dbo].[EmailContactCategory](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](80) COLLATE Hungarian_CI_AS NOT NULL,
 CONSTRAINT [pEmailContactCategory] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[EmailAddressBook]    Script Date: 10/01/2015 09:11:13 ******/
CREATE TABLE [dbo].[EmailAddressBook](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ForName] [nvarchar](50) COLLATE Hungarian_CI_AS NOT NULL,
	[LastName] [nvarchar](50) COLLATE Hungarian_CI_AS NULL,
	[Note] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
	[Address] [nvarchar](128) COLLATE Hungarian_CI_AS NULL,
	[EmailContactCategoryId] [int] NULL,
 CONSTRAINT [pEmailAddressBook] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EmailAddressBook]  WITH CHECK ADD  CONSTRAINT [fEmailAddressBookEmailContactCategory] FOREIGN KEY([EmailContactCategoryId])
REFERENCES [dbo].[EmailContactCategory] ([Id])
ALTER TABLE [dbo].[EmailAddressBook] CHECK CONSTRAINT [fEmailAddressBookEmailContactCategory]




/****** Object:  Table [dbo].[EmailAddressBookValue]    Script Date: 10/01/2015 09:11:59 ******/
CREATE TABLE [dbo].[EmailAddressBookValue](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[EmailPhoneBookId] [int] NOT NULL,
	[Value] [nvarchar](32) COLLATE Hungarian_CI_AS NOT NULL,
 CONSTRAINT [pEmailAddressBookValue] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EmailAddressBookValue]  WITH CHECK ADD  CONSTRAINT [fEmailAddressBookValueEmailAddressBook] FOREIGN KEY([EmailPhoneBookId])
REFERENCES [dbo].[EmailAddressBook] ([Id])
ALTER TABLE [dbo].[EmailAddressBookValue] CHECK CONSTRAINT [fEmailAddressBookValueEmailAddressBook]




/****** Object:  TableType    Script Date: 04/19/2015 08:38:59 ******/
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (710, 'Sms', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (711, 'SmsContactCategory', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (712, 'SmsPhoneBook', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (713, 'SmsPhoneBookValue', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (714, 'SmsRelation', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (715, 'EmailContactCategory', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (716, 'EmailAddressBook', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (717, 'EmailAddressBookValue', 0, 0)