/****** Object:  Table [dbo].[RegistrarTask]    Script Date: 07/11/2015 12:37:47 ******/
CREATE TABLE [dbo].[RegistrarTask](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[RegistrarId] [int] NOT NULL,
	[ResponsibleUserId] [int] NOT NULL,
	[DeadLine] [datetime] NOT NULL,
	[TaskDescription] [nvarchar](max) COLLATE Hungarian_CI_AS NOT NULL,
	[LicencingDate] [datetime] NULL,
	[LicencingDescription] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
 CONSTRAINT [pRegistrarTask] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[RegistrarTask]  WITH CHECK ADD  CONSTRAINT [fRegistrarTaskContoUser] FOREIGN KEY([ResponsibleUserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[RegistrarTask] CHECK CONSTRAINT [fRegistrarTaskContoUser]

ALTER TABLE [dbo].[RegistrarTask]  WITH CHECK ADD  CONSTRAINT [fRegistrarTaskRegistrar] FOREIGN KEY([RegistrarId])
REFERENCES [dbo].[Registrar] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[RegistrarTask] CHECK CONSTRAINT [fRegistrarTaskRegistrar]




/****** Object:  Table [dbo].[RegistrarToRegistrar]    Script Date: 07/23/2015 11:13:59 ******/
CREATE TABLE [dbo].[RegistrarToRegistrar](
	[FromRegistrarId] [int] NOT NULL,
	[ToRegistrarId] [int] NOT NULL,
 CONSTRAINT [pRegistrarToRegistrar] PRIMARY KEY CLUSTERED 
(
	[FromRegistrarId] ASC,
	[ToRegistrarId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[RegistrarToRegistrar]  WITH CHECK ADD  CONSTRAINT [fRegistrarToRegistrarRegistrarFrom] FOREIGN KEY([FromRegistrarId])
REFERENCES [dbo].[Registrar] ([Id])
ALTER TABLE [dbo].[RegistrarToRegistrar] CHECK CONSTRAINT [fRegistrarToRegistrarRegistrarFrom]

ALTER TABLE [dbo].[RegistrarToRegistrar]  WITH CHECK ADD  CONSTRAINT [fRegistrarToRegistrarRegistrarTo] FOREIGN KEY([ToRegistrarId])
REFERENCES [dbo].[Registrar] ([Id])
ALTER TABLE [dbo].[RegistrarToRegistrar] CHECK CONSTRAINT [fRegistrarToRegistrarRegistrarTo]





/****** Object:  Table [dbo].[TableType]    Script Date: 05/01/2014 09:55:40 ******/
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (720, 'RegistrarTask', 0, 0)





/****** Object:  Table [dbo].[RegistrarFile]    Script Date: 05/01/2014 09:55:40 ******/
ALTER TABLE [dbo].[RegistrarFile] ADD  [AggregateCounter] [int] NOT NULL DEFAULT(0)
ALTER TABLE [dbo].[RegistrarFile] ALTER COLUMN [VoucherSign] [nvarchar](6)





/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 05/22/2015 21:26:52 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ClicxoftDatabaseRevison]') AND type in (N'U'))
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	CREATE TABLE [dbo].[ClicxoftDatabaseRevison](
		[Revision] [int] NOT NULL,
		[ProductId] [int] NOT NULL,
		[Performed] [datetime] NOT NULL,
	 CONSTRAINT [pClicxoftDatabaseRevison] PRIMARY KEY CLUSTERED 
	(
		[Revision] ASC,
		[ProductId] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1000, 'ClicxoftDatabaseRevison', 0, 0)
END


/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 05/22/2015 09:55:40 ******/
INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (801, 8, '2015.07.01')