
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON


/****** Object:  Table [dbo].[ContractEmailTemplate]    Script Date: 04/25/2015 12:48:05 ******/
CREATE TABLE [dbo].[QuestionnairEmailTemplate](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](80) COLLATE Hungarian_CI_AS NOT NULL,
	[Subject] [nvarchar](50) COLLATE Hungarian_CI_AS NOT NULL,
	[BodyHtml] [nvarchar](max) COLLATE Hungarian_CI_AS NOT NULL,
	[BodyText] [nvarchar](max) COLLATE Hungarian_CI_AS NOT NULL,
	[IsHtml] [bit] NOT NULL CONSTRAINT [dContractEmailTemplateIsHtml]  DEFAULT ((0)),
 CONSTRAINT [pContractEmailTemplate] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[QuestionnairSmsTemplate]    Script Date: 04/25/2015 12:49:29 ******/
CREATE TABLE [dbo].[QuestionnairSmsTemplate](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) COLLATE Hungarian_CI_AS NOT NULL,
	[Body] [nvarchar](max) COLLATE Hungarian_CI_AS NOT NULL,
	[ProductId] [int] NULL,
 CONSTRAINT [pSmsTemplate] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[QuestionnaireTemplate]    Script Date: 03/25/2015 09:08:56 ******/
CREATE TABLE [dbo].[QuestionnaireTemplate](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) COLLATE Hungarian_CI_AS NOT NULL,
 CONSTRAINT [pQuestionnaireTemplate] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[QuestionnaireTemplateItem]    Script Date: 03/25/2015 09:10:06 ******/
CREATE TABLE [dbo].[QuestionnaireTemplateItem](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Description] [nvarchar](max) COLLATE Hungarian_CI_AS NOT NULL,
	[QuestionnaireTemplateId] [int] NOT NULL,
	[ExtraDataId] [int] NOT NULL,
 CONSTRAINT [pQuestionnaireTemplateItem] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[QuestionnaireTemplateItem]  WITH CHECK ADD  CONSTRAINT [fQuestionnaireTemplateItemExtraData] FOREIGN KEY([ExtraDataId])
REFERENCES [dbo].[ExtraData] ([Id])
ALTER TABLE [dbo].[QuestionnaireTemplateItem] CHECK CONSTRAINT [fQuestionnaireTemplateItemExtraData]

ALTER TABLE [dbo].[QuestionnaireTemplateItem]  WITH CHECK ADD  CONSTRAINT [fQuestionnaireTemplateItemQuestionnaireTemplate] FOREIGN KEY([QuestionnaireTemplateId])
REFERENCES [dbo].[QuestionnaireTemplate] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[QuestionnaireTemplateItem] CHECK CONSTRAINT [fQuestionnaireTemplateItemQuestionnaireTemplate]




/****** Object:  Table [dbo].[QuestionnairFile]    Script Date: 03/24/2015 14:09:45 ******/
CREATE TABLE [dbo].[QuestionnairFile](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AvatarId] [int] NULL,
	[Name] [nvarchar](50) COLLATE Hungarian_CI_AS NOT NULL,
	[QuestionnaireTemplateId] [int] NULL,
	[CurrenCounter] [int] NOT NULL CONSTRAINT [dQuestionnairFileCurrenCounter]  DEFAULT ((0)),
	[VoucherSign] [nvarchar](4) COLLATE Hungarian_CI_AS NOT NULL,
 CONSTRAINT [pQuestionnairFile] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[QuestionnairFile]  WITH CHECK ADD  CONSTRAINT [fQuestionnairFileQuestionnaireTemplate] FOREIGN KEY([QuestionnaireTemplateId])
REFERENCES [dbo].[QuestionnaireTemplate] ([Id])
ALTER TABLE [dbo].[QuestionnairFile] CHECK CONSTRAINT [fQuestionnairFileQuestionnaireTemplate]




/****** Object:  Table [dbo].[Questionnair]    Script Date: 03/24/2015 14:10:21 ******/
CREATE TABLE [dbo].[Questionnair](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[timestamp] [timestamp] NOT NULL,
	[AvatarId] [int] NULL,
	[Name] [nvarchar](80) COLLATE Hungarian_CI_AS NULL,
	[OrdinalNumber] [int] NULL,
	[Company] [nvarchar](80) COLLATE Hungarian_CI_AS NULL,
	[Email] [nvarchar](50) COLLATE Hungarian_CI_AS NULL,
	[Phone] [nvarchar](32) COLLATE Hungarian_CI_AS NULL,
	[CreatedDate] [datetime] NOT NULL,
	[ContoUserId] [int] NOT NULL,
	[CreatedPalce] [nvarchar](32) COLLATE Hungarian_CI_AS NULL,
	[QuestionnairFileId] [int] NOT NULL,
	[VoucheNum] [nvarchar](16) COLLATE Hungarian_CI_AS NULL,
 CONSTRAINT [pQuestionnair] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[Questionnair]  WITH CHECK ADD  CONSTRAINT [fQuestionnairContoUser] FOREIGN KEY([ContoUserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[Questionnair] CHECK CONSTRAINT [fQuestionnairContoUser]

ALTER TABLE [dbo].[Questionnair]  WITH CHECK ADD  CONSTRAINT [fQuestionnairQuestionnairFile] FOREIGN KEY([QuestionnairFileId])
REFERENCES [dbo].[QuestionnairFile] ([Id])
ALTER TABLE [dbo].[Questionnair] CHECK CONSTRAINT [fQuestionnairQuestionnairFile]




/****** Object:  Table [dbo].[QuestionnairProcessing]    Script Date: 04/03/2015 10:33:08 ******/
CREATE TABLE [dbo].[QuestionnairProcessing](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[QuestionnaireTemplateId] [int] NOT NULL,
	[Name] [nvarchar](80) COLLATE Hungarian_CI_AS NOT NULL,
	[Description] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
 CONSTRAINT [pQuestionnaireProcessing] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[QuestionnairProcessing]  WITH CHECK ADD  CONSTRAINT [fQuestionnaireTemplateQuestionnaireProcessing] FOREIGN KEY([QuestionnaireTemplateId])
REFERENCES [dbo].[QuestionnaireTemplate] ([Id])
ALTER TABLE [dbo].[QuestionnairProcessing] CHECK CONSTRAINT [fQuestionnaireTemplateQuestionnaireProcessing]




/****** Object:  Table [dbo].[QuestionnairProcessingItem]    Script Date: 04/03/2015 10:33:54 ******/
CREATE TABLE [dbo].[QuestionnairProcessingItem](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](80) COLLATE Hungarian_CI_AS NOT NULL,
	[ExtraDataId1] [int] NULL,
	[Value1] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
	[ExtraDataId12] [int] NULL,
	[Value12] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
	[QuestionnairProcessingId] [int] NOT NULL,
	[RealValue1] [nvarchar](80) COLLATE Hungarian_CI_AS NULL,
	[RealValue12] [nvarchar](80) COLLATE Hungarian_CI_AS NULL,
	[GraphColor] [int] NULL,
 CONSTRAINT [pQuestionnairProcess] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[QuestionnairProcessingItem]  WITH CHECK ADD  CONSTRAINT [fQuestionnairProcessingItemQuestionnairProcessing] FOREIGN KEY([QuestionnairProcessingId])
REFERENCES [dbo].[QuestionnairProcessing] ([Id])
ALTER TABLE [dbo].[QuestionnairProcessingItem] CHECK CONSTRAINT [fQuestionnairProcessingItemQuestionnairProcessing]




/****** Tblk felvtele ******/
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (700, 'QuestionnairFile', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (701, 'Questionnair', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (702, 'QuestionnaireTemplate', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (703, 'QuestionnaireTemplateItem', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (704, 'QuestionnairProcessing', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (705, 'QuestionnairProcessingItem', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (706, 'QuestionnairEmailTemplate', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (707, 'QuestionnairSmsTemplate', 0, 0)



/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 01/04/2015 21:26:52 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ClicxoftDatabaseRevison]') AND type in (N'U'))
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	CREATE TABLE [dbo].[ClicxoftDatabaseRevison](
		[Revision] [int] NOT NULL,
		[ProductId] [int] NOT NULL,
		[Performed] [datetime] NOT NULL,
	 CONSTRAINT [pClicxoftDatabaseRevison] PRIMARY KEY CLUSTERED 
	(
		[Revision] ASC,
		[ProductId] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1000, 'ClicxoftDatabaseRevison', 0, 0)
END

IF (SELECT [Revision] FROM [ClicxoftDatabaseRevison] WHERE [ProductId] = 7) IS NULL
BEGIN
	INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (701, 7, '2015.01.01')
END