/****** Object:  Table [dbo].[PartnerEventType]    Script Date: 10/06/2015 21:48:29 ******/
CREATE TABLE [dbo].[PartnerEventType](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) COLLATE Hungarian_CI_AS NOT NULL,
 CONSTRAINT [pPartnerEventType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[PartnerEvent]    Script Date: 10/06/2015 21:48:50 ******/
CREATE TABLE [dbo].[PartnerEvent](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[PartnerId] [int] NOT NULL,
	[EventDate] [datetime] NOT NULL,
	[EventType] [int] NOT NULL,
	[Name] [nvarchar](80) COLLATE Hungarian_CI_AS NOT NULL,
	[Description] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
	[AffairFromDate] [datetime] NULL,
	[AffairToDate] [datetime] NULL,
	[AffairVoice] [varbinary](max) NULL,
	[OwnerUserId] [int] NULL,
	[VoiceFilePath] [nvarchar](256) NULL,
 CONSTRAINT [pPartnerEvent] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PartnerEvent]  WITH CHECK ADD  CONSTRAINT [fPartnerEventPartner] FOREIGN KEY([PartnerId])
REFERENCES [dbo].[Partner] ([Id])
ALTER TABLE [dbo].[PartnerEvent] CHECK CONSTRAINT [fPartnerEventPartner]

ALTER TABLE [dbo].[PartnerEvent]  WITH CHECK ADD  CONSTRAINT [fPartnerEventPartnerEventType] FOREIGN KEY([EventType])
REFERENCES [dbo].[PartnerEventType] ([Id])
ALTER TABLE [dbo].[PartnerEvent] CHECK CONSTRAINT [fPartnerEventPartnerEventType]




/****** Object:  Table [dbo].[PartnerTodo]    Script Date: 03/05/2016 11:15:38 ******/
CREATE TABLE [dbo].[PartnerTodo](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[PartnerId] [int] NOT NULL,
	[Todo] [nvarchar](128) COLLATE Hungarian_CI_AS NOT NULL,
	[Note] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
	[DeadLine] [datetime] NULL,
	[PeriodType] [int] NULL,
	[DayOfPeriod] [int] NULL,
	[IsClosed] [bit] NOT NULL CONSTRAINT [DF_PartnerTodo_IsClosed]  DEFAULT ((0)),
	[ResponsibleUserId] [int] NULL,
 CONSTRAINT [PK_PartnerTodo] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PartnerTodo]  WITH CHECK ADD  CONSTRAINT [FK_PartnerTodo_Partner] FOREIGN KEY([PartnerId])
REFERENCES [dbo].[Partner] ([Id])
ALTER TABLE [dbo].[PartnerTodo] CHECK CONSTRAINT [FK_PartnerTodo_Partner]



/****** Object:  Table [dbo].[PartnerTodoEvent]    Script Date: 03/06/2016 16:29:26 ******/
CREATE TABLE [dbo].[PartnerTodoEvent](
	[PartnerTodoId] [int] NOT NULL,
	[PartnerEventId] [int] NOT NULL,
 CONSTRAINT [PK_PartnerTodoEvent] PRIMARY KEY CLUSTERED 
(
	[PartnerTodoId] ASC,
	[PartnerEventId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PartnerTodoEvent]  WITH CHECK ADD  CONSTRAINT [FK_PartnerTodoEvent_PartnerEvent] FOREIGN KEY([PartnerEventId])
REFERENCES [dbo].[PartnerEvent] ([Id])
ALTER TABLE [dbo].[PartnerTodoEvent] CHECK CONSTRAINT [FK_PartnerTodoEvent_PartnerEvent]

ALTER TABLE [dbo].[PartnerTodoEvent]  WITH CHECK ADD  CONSTRAINT [FK_PartnerTodoEvent_PartnerTodo] FOREIGN KEY([PartnerTodoId])
REFERENCES [dbo].[PartnerTodo] ([Id])
ALTER TABLE [dbo].[PartnerTodoEvent] CHECK CONSTRAINT [FK_PartnerTodoEvent_PartnerTodo]




/****** Object:  Table [dbo].[TableType]    Script Date: 05/01/2014 09:55:40 ******/
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (690, 'PartnerEventType', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (691, 'PartnerEvent', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (692, 'PartnerTodo', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (693, 'PartnerTodoEvent', 0, 0)




/****** Object:  Table [dbo].[SystemDefault]    Script Date: 05/01/2014 09:55:40 ******/
ALTER TABLE [dbo].[SystemDefault] ADD [PartnerNameCheckingCharNumbers] [int] NULL CONSTRAINT [DF_Numbers]  DEFAULT ((3))
ALTER TABLE [dbo].[SystemDefault] ADD [PartnerNameCheckingFromBegin] [bit] NULL CONSTRAINT [DF_FromBegin]  DEFAULT ((0))
ALTER TABLE [dbo].[SystemDefault] ADD [PartnerNameDifferenceIndex] [int] NULL CONSTRAINT [DF_Index]  DEFAULT ((0))




/****** Szerzds belltsok funkcitr felvtele ******/
INSERT INTO [dbo].[FuncSpace] ([Name], Description, Allowed, TypeId) VALUES ('Clicxoft.Partner.Ugyfelszolgalat', 'gyflszolglat funkci', 'True', 1)




/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 01/04/2015 21:26:52 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ClicxoftDatabaseRevison]') AND type in (N'U'))
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	CREATE TABLE [dbo].[ClicxoftDatabaseRevison](
		[Revision] [int] NOT NULL,
		[ProductId] [int] NOT NULL,
		[Performed] [datetime] NOT NULL,
	 CONSTRAINT [pClicxoftDatabaseRevison] PRIMARY KEY CLUSTERED 
	(
		[Revision] ASC,
		[ProductId] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1000, 'ClicxoftDatabaseRevison', 0, 0)
END

IF (SELECT [Revision] FROM [ClicxoftDatabaseRevison] WHERE [ProductId] = 11) IS NULL
BEGIN
	INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (1103, 11, '2016.08.25')
END