/****** Object:  Table [dbo].[PartnerTodo]    Script Date: 03/05/2016 11:15:38 ******/
CREATE TABLE [dbo].[PartnerTodo](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[PartnerId] [int] NOT NULL,
	[Todo] [nvarchar](128) COLLATE Hungarian_CI_AS NOT NULL,
	[Note] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
	[DeadLine] [datetime] NULL,
	[PeriodType] [int] NULL,
	[DayOfPeriod] [int] NULL,
	[IsClosed] [bit] NOT NULL CONSTRAINT [DF_PartnerTodo_IsClosed]  DEFAULT ((0)),
 CONSTRAINT [PK_PartnerTodo] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PartnerTodo]  WITH CHECK ADD  CONSTRAINT [FK_PartnerTodo_Partner] FOREIGN KEY([PartnerId])
REFERENCES [dbo].[Partner] ([Id])
ALTER TABLE [dbo].[PartnerTodo] CHECK CONSTRAINT [FK_PartnerTodo_Partner]



/****** Object:  Table [dbo].[PartnerTodoEvent]    Script Date: 03/06/2016 16:29:26 ******/
CREATE TABLE [dbo].[PartnerTodoEvent](
	[PartnerTodoId] [int] NOT NULL,
	[PartnerEventId] [int] NOT NULL,
 CONSTRAINT [PK_PartnerTodoEvent] PRIMARY KEY CLUSTERED 
(
	[PartnerTodoId] ASC,
	[PartnerEventId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PartnerTodoEvent]  WITH CHECK ADD  CONSTRAINT [FK_PartnerTodoEvent_PartnerEvent] FOREIGN KEY([PartnerEventId])
REFERENCES [dbo].[PartnerEvent] ([Id])
ALTER TABLE [dbo].[PartnerTodoEvent] CHECK CONSTRAINT [FK_PartnerTodoEvent_PartnerEvent]

ALTER TABLE [dbo].[PartnerTodoEvent]  WITH CHECK ADD  CONSTRAINT [FK_PartnerTodoEvent_PartnerTodo] FOREIGN KEY([PartnerTodoId])
REFERENCES [dbo].[PartnerTodo] ([Id])
ALTER TABLE [dbo].[PartnerTodoEvent] CHECK CONSTRAINT [FK_PartnerTodoEvent_PartnerTodo]




/****** Object:  Table [dbo].[TableType]    Script Date: 05/01/2014 09:55:40 ******/
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (692, 'PartnerTodo', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (693, 'PartnerTodoEvent', 0, 0)




/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 05/22/2015 21:26:52 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ClicxoftDatabaseRevison]') AND type in (N'U'))
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	CREATE TABLE [dbo].[ClicxoftDatabaseRevison](
		[Revision] [int] NOT NULL,
		[ProductId] [int] NOT NULL,
		[Performed] [datetime] NOT NULL,
	 CONSTRAINT [pClicxoftDatabaseRevison] PRIMARY KEY CLUSTERED 
	(
		[Revision] ASC,
		[ProductId] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1000, 'ClicxoftDatabaseRevison', 0, 0)
END


/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 05/22/2015 09:55:40 ******/
INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (1102, 11, '2016.03.01')