/****** Object:  Table [dbo].[LeasingLog]    Script Date: 10/13/2016 12:55:30 ******/
CREATE TABLE [dbo].[LeasingLog](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SrcAvatarId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[LogDate] [datetime] NOT NULL,
	[LogText] [nvarchar](max) NOT NULL,
 CONSTRAINT [PK_LeasingLog] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]




/****** Object:  Table [dbo].[LeasingEventCategory]    Script Date: 10/12/2016 13:49:31 ******/
CREATE TABLE [dbo].[LeasingEventCategory](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_LeasingEventCategory] PRIMARY KEY CLUSTERED 
(	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[LeasingOutOrderType]    Script Date: 10/09/2016 21:20:06 ******/
CREATE TABLE [dbo].[LeasingOutOrderType](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_LeasingOutOrderType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[LeasingCategory]    Script Date: 10/09/2016 21:20:52 ******/
CREATE TABLE [dbo].[LeasingCategory](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_LeasingCategory] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]




/****** Object:  Table [dbo].[LeasingManufacturer]    Script Date: 10/09/2016 21:22:01 ******/
CREATE TABLE [dbo].[LeasingManufacturer](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_LeasingManufacturer] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[LeasingProductType]    Script Date: 10/09/2016 21:21:52 ******/
CREATE TABLE [dbo].[LeasingProductType](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_LeasingProductType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[LeasingServices]    Script Date: 10/09/2016 21:22:55 ******/
CREATE TABLE [dbo].[LeasingServices](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[UnitPrice] [decimal](18, 2) NOT NULL,
	[MeasureSign] [nvarchar](16) NOT NULL,
	[Currency] [nchar](3) NULL,
 CONSTRAINT [PK_LeasingPassiveType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[LeasingProduct]    Script Date: 10/09/2016 21:23:43 ******/
CREATE TABLE [dbo].[LeasingProduct](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AvatarId] [int] NULL,
	[Name] [nvarchar](50) NOT NULL,
	[LeasingCategoryId] [int] NULL,
	[LeasingPassiveTypeId] [int] NULL,
	[LeasingProductTypeId] [int] NULL,
	[LeasingManufacturerId] [int] NULL,
	[Value] [decimal](18, 2) NULL,
	[BuyingDate] [datetime] NULL,
	[Identifier] [nvarchar](50) NULL,
	[SerialNumber] [nvarchar](50) NULL,
	[OperatingFee] [decimal](18, 2) NULL,
	[NonOperatingFee] [decimal](18, 2) NULL,
	[DevOperatingFee] [decimal](18, 2) NULL,
	[DevizaNonOperatingFee] [decimal](18, 2) NULL,
	[FeePeriod] [int] NULL,
	[ProductImage] [varbinary](max) NULL,
	[Weight] [decimal](18, 2) NULL,
	[LeasingStatus] [int] NOT NULL,
	[Note] [nvarchar](max) NULL,
	[SizeX] [decimal](18, 2) NULL,
	[SizeY] [decimal](18, 2) NULL,
	[SizeZ] [decimal](18, 2) NULL,
	[Quantity] [decimal](18, 2) NULL,
	[Vtsz] [nvarchar](20) NULL,
	[StoreName] [nvarchar](20) NULL, 
	[Pillar] [nvarchar](10) NULL, 
	[Shelf] [nvarchar](10) NULL, 
	[Tray] [nvarchar](10) NULL,
 CONSTRAINT [PK_LeasingProduct] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 CONSTRAINT [IX_LeasingProduct_Identifier] UNIQUE NONCLUSTERED 
(
	[Identifier] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 CONSTRAINT [IX_LeasingProduct_SerialNumber] UNIQUE NONCLUSTERED 
(
	[SerialNumber] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
ALTER TABLE [dbo].[LeasingProduct]  WITH CHECK ADD  CONSTRAINT [FK_LeasingProduct_Avatar] FOREIGN KEY([AvatarId])
REFERENCES [dbo].[Avatar] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[LeasingProduct] CHECK CONSTRAINT [FK_LeasingProduct_Avatar]
ALTER TABLE [dbo].[LeasingProduct]  WITH CHECK ADD  CONSTRAINT [FK_LeasingProduct_LeasingCategory] FOREIGN KEY([LeasingCategoryId])
REFERENCES [dbo].[LeasingCategory] ([Id])
ALTER TABLE [dbo].[LeasingProduct] CHECK CONSTRAINT [FK_LeasingProduct_LeasingCategory]
ALTER TABLE [dbo].[LeasingProduct]  WITH CHECK ADD  CONSTRAINT [FK_LeasingProduct_LeasingManufacturer] FOREIGN KEY([LeasingManufacturerId])
REFERENCES [dbo].[LeasingManufacturer] ([Id])
ALTER TABLE [dbo].[LeasingProduct] CHECK CONSTRAINT [FK_LeasingProduct_LeasingManufacturer]
ALTER TABLE [dbo].[LeasingProduct]  WITH CHECK ADD  CONSTRAINT [FK_LeasingProduct_LeasingProductType] FOREIGN KEY([LeasingProductTypeId])
REFERENCES [dbo].[LeasingProductType] ([Id])
ALTER TABLE [dbo].[LeasingProduct] CHECK CONSTRAINT [FK_LeasingProduct_LeasingProductType]



/****** Object:  Table [dbo].[LeasingEvent]    Script Date: 10/09/2016 21:24:51 ******/
CREATE TABLE [dbo].[LeasingEvent](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[LeasingEventCategoryId] [int] NOT NULL,
	[SrcAvatarId] [int] NOT NULL,
	[Description] [nvarchar](max) NOT NULL,
	[EventDate] [datetime] NOT NULL,
	[IsGenerated] [bit] NOT NULL,
	[UserId] [int] NOT NULL,
 CONSTRAINT [PK_LeasingEvent] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
ALTER TABLE [dbo].[LeasingEvent]  WITH CHECK ADD  CONSTRAINT [FK_LeasingEvent_ContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[LeasingEvent] CHECK CONSTRAINT [FK_LeasingEvent_ContoUser]
ALTER TABLE [dbo].[LeasingEvent]  WITH CHECK ADD  CONSTRAINT [FK_LeasingEvent_LeasingEventCategory] FOREIGN KEY([LeasingEventCategoryId])
REFERENCES [dbo].[LeasingEventCategory] ([Id])
ALTER TABLE [dbo].[LeasingEvent] CHECK CONSTRAINT [FK_LeasingEvent_LeasingEventCategory]
ALTER TABLE [dbo].[LeasingEvent] ADD  CONSTRAINT [DF_LeasingEvent_IsGenerated]  DEFAULT ((0)) FOR [IsGenerated]



/****** Object:  Table [dbo].[LeasingTodo]    Script Date: 10/09/2016 21:25:37 ******/
CREATE TABLE [dbo].[LeasingTodo](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](80) NOT NULL,
	[SrcAvatarId] [int] NOT NULL,
	[TodoDate] [datetime] NOT NULL,
	[Deadline] [datetime] NOT NULL,
	[ResponsibleUserId] [int] NOT NULL,
	[Note] [nvarchar](max) NULL,
	[IsClosed] [bit] NOT NULL,
 CONSTRAINT [PK_LeasingTodo] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
ALTER TABLE [dbo].[LeasingTodo]  WITH CHECK ADD  CONSTRAINT [FK_LeasingTodo_ContoUser] FOREIGN KEY([ResponsibleUserId])
REFERENCES [dbo].[ContoUser] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[LeasingTodo] CHECK CONSTRAINT [FK_LeasingTodo_ContoUser]
ALTER TABLE [dbo].[LeasingTodo] ADD  CONSTRAINT [DF_LeasingTodo_IsClosed]  DEFAULT ((0)) FOR [IsClosed]



/****** Object:  Table [dbo].[LeasingOutOrderItem]    Script Date: 10/09/2016 21:26:32 ******/
CREATE TABLE [dbo].[LeasingOutOrderItem](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[LeasingOutOrderTypeId] [int] NOT NULL,
	[LeasingProductId] [int] NOT NULL,
	[StartDate] [datetime] NOT NULL,
	[Enddate] [datetime] NULL,
 CONSTRAINT [PK_LeasingOutOrderItem] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[LeasingOutOrderItem]  WITH CHECK ADD  CONSTRAINT [FK_LeasingOutOrderItem_LeasingOutOrderType] FOREIGN KEY([LeasingOutOrderTypeId])
REFERENCES [dbo].[LeasingOutOrderType] ([Id])
ALTER TABLE [dbo].[LeasingOutOrderItem] CHECK CONSTRAINT [FK_LeasingOutOrderItem_LeasingOutOrderType]
ALTER TABLE [dbo].[LeasingOutOrderItem]  WITH CHECK ADD  CONSTRAINT [FK_LeasingOutOrderItem_LeasingProduct] FOREIGN KEY([LeasingProductId])
REFERENCES [dbo].[LeasingProduct] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[LeasingOutOrderItem] CHECK CONSTRAINT [FK_LeasingOutOrderItem_LeasingProduct]



/****** Object:  Table [dbo].[LeasingAccessories]    Script Date: 10/09/2016 21:27:02 ******/
CREATE TABLE [dbo].[LeasingAccessories](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[LeasingProductId] [int] NOT NULL,
	[Quantity] [decimal](18, 2) NOT NULL,
	[BuyingDate] [datetime] NULL,
	[BuyingPrice] [decimal](18, 2) NULL,
	[IsActive] [bit] NOT NULL,
	[InvalidatedDate] [datetime] NULL,
 CONSTRAINT [PK_LeasingOutOrder] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[LeasingAccessories]  WITH CHECK ADD  CONSTRAINT [FK_LeasingAccessories_LeasingProduct] FOREIGN KEY([LeasingProductId])
REFERENCES [dbo].[LeasingProduct] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[LeasingAccessories] CHECK CONSTRAINT [FK_LeasingAccessories_LeasingProduct]
ALTER TABLE [dbo].[LeasingAccessories] ADD  CONSTRAINT [DF_LeasingAccessories_IsActive]  DEFAULT ((1)) FOR [IsActive]



/****** Object:  Table [dbo].[LeasingCalendar]    Script Date: 10/09/2016 21:27:42 ******/
CREATE TABLE [dbo].[LeasingCalendar](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[LeasingProductId] [int] NOT NULL,
	[StartDate] [datetime] NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[PartnerId] [int] NOT NULL,
	[Identifier] [uniqueidentifier] NULL,
	[LeasingStatus] [int] NOT NULL,
	[OperatingStartDate] [datetime] NOT NULL,
	[OperatingEndDate] [datetime] NOT NULL,
 CONSTRAINT [PK_LeasingCalendar] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[LeasingCalendar]  WITH CHECK ADD  CONSTRAINT [FK_LeasingCalendar_LeasingCalendar] FOREIGN KEY([PartnerId])
REFERENCES [dbo].[Partner] ([Id])
ALTER TABLE [dbo].[LeasingCalendar] CHECK CONSTRAINT [FK_LeasingCalendar_LeasingCalendar]
ALTER TABLE [dbo].[LeasingCalendar]  WITH CHECK ADD  CONSTRAINT [FK_LeasingCalendar_LeasingProduct] FOREIGN KEY([LeasingProductId])
REFERENCES [dbo].[LeasingProduct] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[LeasingCalendar] CHECK CONSTRAINT [FK_LeasingCalendar_LeasingProduct]



/****** Object:  Table [dbo].[LeasingFile]    Script Date: 10/09/2016 21:28:26 ******/
CREATE TABLE [dbo].[LeasingFile](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AvatarId] [int] NULL,
	[Name] [nvarchar](80) NOT NULL,
	[CurrentCounter] [int] NOT NULL,
	[VoucherSign] [nvarchar](5) NOT NULL,
	[YearNum] [nvarchar](4) NOT NULL,
	[Digits] [int] NOT NULL,
 CONSTRAINT [PK_LeasingFile] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[LeasingProject]    Script Date: 10/09/2016 21:28:51 ******/
CREATE TABLE [dbo].[LeasingProject](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AvatarId] [int] NULL,
	[LeasingFileId] [int] NOT NULL,
	[VoucherNum] [nvarchar](20) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[Status] [int] NOT NULL,
	[ProjectDate] [datetime] NOT NULL,
	[StartDate] [datetime] NOT NULL,
	[Enddate] [datetime] NOT NULL,
	[PartnerId] [int] NOT NULL,
	[OperatingStartDate] [datetime] NOT NULL,
	[OperatingEndDate] [datetime] NOT NULL,
	[DeliveryAddress1] [nvarchar](50) NULL,
	[DeliveryAddress2] [nvarchar](50) NULL,
	[DeliveryAddress3] [nvarchar](50) NULL,
	[ContactId] [int] NULL,
	[IsCurrency] [bit] NOT NULL,
	[Note] [nvarchar](max) NULL,
 CONSTRAINT [PK_LeasingProject] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[LeasingProject]  WITH CHECK ADD  CONSTRAINT [FK_LeasingProject_Contact] FOREIGN KEY([ContactId])
REFERENCES [dbo].[Contact] ([Id])
ALTER TABLE [dbo].[LeasingProject] CHECK CONSTRAINT [FK_LeasingProject_Contact]
ALTER TABLE [dbo].[LeasingProject]  WITH CHECK ADD  CONSTRAINT [FK_LeasingProject_Partner] FOREIGN KEY([PartnerId])
REFERENCES [dbo].[Partner] ([Id])
ALTER TABLE [dbo].[LeasingProject] CHECK CONSTRAINT [FK_LeasingProject_Partner]
ALTER TABLE [dbo].[LeasingProject] ADD  CONSTRAINT [DF_LeasingProject_IsClosed]  DEFAULT ((0)) FOR [Status]
ALTER TABLE [dbo].[LeasingProject] ADD  CONSTRAINT [DF_LeasingProject_IsCurrency]  DEFAULT ((0)) FOR [IsCurrency]



/****** Object:  Table [dbo].[LeasingProjectLeasingCalendar]    Script Date: 10/09/2016 21:29:29 ******/
CREATE TABLE [dbo].[LeasingProjectLeasingCalendar](
	[LeasingProjectId] [int] NOT NULL,
	[LeasingCalendarId] [int] NOT NULL
) ON [PRIMARY]
ALTER TABLE [dbo].[LeasingProjectLeasingCalendar]  WITH CHECK ADD  CONSTRAINT [FK_LeasingProjectLeasingCalendar_LeasingCalendar] FOREIGN KEY([LeasingCalendarId])
REFERENCES [dbo].[LeasingCalendar] ([Id])
ALTER TABLE [dbo].[LeasingProjectLeasingCalendar] CHECK CONSTRAINT [FK_LeasingProjectLeasingCalendar_LeasingCalendar]
ALTER TABLE [dbo].[LeasingProjectLeasingCalendar]  WITH CHECK ADD  CONSTRAINT [FK_LeasingProjectLeasingCalendar_LeasingProject] FOREIGN KEY([LeasingProjectId])
REFERENCES [dbo].[LeasingProject] ([Id])
ALTER TABLE [dbo].[LeasingProjectLeasingCalendar] CHECK CONSTRAINT [FK_LeasingProjectLeasingCalendar_LeasingProject]



/****** Object:  Table [dbo].[LeasingProjectServices]    Script Date: 10/09/2016 21:30:00 ******/
CREATE TABLE [dbo].[LeasingProjectServices](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[LeasingProjectId] [int] NOT NULL,
	[LeasingServiceId] [int] NOT NULL,
	[Quantity] [decimal](18, 2) NOT NULL,
 CONSTRAINT [PK_LeasingProjectServices] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[LeasingProjectServices]  WITH CHECK ADD  CONSTRAINT [FK_LeasingProjectServices_LeasingProject] FOREIGN KEY([LeasingProjectId])
REFERENCES [dbo].[LeasingProject] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[LeasingProjectServices] CHECK CONSTRAINT [FK_LeasingProjectServices_LeasingProject]
ALTER TABLE [dbo].[LeasingProjectServices]  WITH CHECK ADD  CONSTRAINT [FK_LeasingProjectServices_LeasingServices] FOREIGN KEY([LeasingServiceId])
REFERENCES [dbo].[LeasingServices] ([Id])
ALTER TABLE [dbo].[LeasingProjectServices] CHECK CONSTRAINT [FK_LeasingProjectServices_LeasingServices]



/****** Object:  Table [dbo].[LeasingOfferNote]    Script Date: 10/17/2016 16:54:51 ******/
CREATE TABLE [dbo].[LeasingOfferNote](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[Note] [nvarchar](max) NULL,
 CONSTRAINT [PK_LeasingOfferNote] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]



/****** Object:  Table [dbo].[LeasingOffer]    Script Date: 10/17/2016 16:55:49 ******/
SET ANSI_NULLS ON
CREATE TABLE [dbo].[LeasingOffer](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[LeasingProjectId] [int] NOT NULL,
	[EmployeeContactId] [int] NULL,
	[EmployeePhone] [nvarchar](50) NULL,
	[EmployeeEmail] [nvarchar](50) NULL,
	[Locale] [nvarchar](50) NULL,
	[Installation] [nvarchar](50) NULL,
	[Destruction] [nvarchar](50) NULL,
 CONSTRAINT [PK_LeasingDeliveryNote] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[LeasingOffer]  WITH CHECK ADD  CONSTRAINT [FK_LeasingDeliveryNote_Contact] FOREIGN KEY([EmployeeContactId])
REFERENCES [dbo].[Contact] ([Id])
ALTER TABLE [dbo].[LeasingOffer] CHECK CONSTRAINT [FK_LeasingDeliveryNote_Contact]
ALTER TABLE [dbo].[LeasingOffer]  WITH CHECK ADD  CONSTRAINT [FK_LeasingDeliveryNote_LeasingProject] FOREIGN KEY([LeasingProjectId])
REFERENCES [dbo].[LeasingProject] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[LeasingOffer] CHECK CONSTRAINT [FK_LeasingDeliveryNote_LeasingProject]



/****** Object:  Table [dbo].[LeasingOfferItem]    Script Date: 10/17/2016 16:56:22 ******/
SET ANSI_NULLS ON
CREATE TABLE [dbo].[LeasingOfferItem](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[LeasingOfferId] [int] NOT NULL,
	[Item] [nvarchar](80) NOT NULL,
	[Quantity] [decimal](18, 2) NOT NULL,
	[MeasureSign] [nvarchar](20) NULL,
	[UnitPrice] [decimal](18, 2) NOT NULL,
	[Discount] [decimal](18, 2) NOT NULL,
 CONSTRAINT [PK_LeasingDeliveryNoteItem] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[LeasingOfferItem]  WITH CHECK ADD  CONSTRAINT [FK_LeasingOfferItem_LeasingOffer] FOREIGN KEY([LeasingOfferId])
REFERENCES [dbo].[LeasingOffer] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[LeasingOfferItem] CHECK CONSTRAINT [FK_LeasingOfferItem_LeasingOffer]




/****** Object:  Table [dbo].[LeasingRelatedProduct]    Script Date: 12/08/2016 18:22:28 ******/
CREATE TABLE [dbo].[LeasingRelatedProduct](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ProductId] [int] NOT NULL,
	[RelatedId] [int] NOT NULL,
 CONSTRAINT [PK_LeasingRelatedProduct] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[LeasingRelatedProduct]  WITH CHECK ADD  CONSTRAINT [FK_LeasingRelatedProduct_LeasingProduct] FOREIGN KEY([ProductId])
REFERENCES [dbo].[LeasingProduct] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[LeasingRelatedProduct] CHECK CONSTRAINT [FK_LeasingRelatedProduct_LeasingProduct]
ALTER TABLE [dbo].[LeasingRelatedProduct]  WITH CHECK ADD  CONSTRAINT [FK_LeasingRelatedProduct_LeasingProduct1] FOREIGN KEY([RelatedId])
REFERENCES [dbo].[LeasingProduct] ([Id])
ALTER TABLE [dbo].[LeasingRelatedProduct] CHECK CONSTRAINT [FK_LeasingRelatedProduct_LeasingProduct1]






/****** Object:  Table [dbo].[TableType]    Script Date: 05/01/2014 09:55:40 ******/
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (500, 'LeasingProduct', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (501, 'LeasingProject', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (502, 'LeasingFile', 1, 0)




/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 01/04/2015 21:26:52 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ClicxoftDatabaseRevison]') AND type in (N'U'))
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	CREATE TABLE [dbo].[ClicxoftDatabaseRevison](
		[Revision] [int] NOT NULL,
		[ProductId] [int] NOT NULL,
		[Performed] [datetime] NOT NULL,
	 CONSTRAINT [pClicxoftDatabaseRevison] PRIMARY KEY CLUSTERED 
	(
		[Revision] ASC,
		[ProductId] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1000, 'ClicxoftDatabaseRevison', 0, 0)
END

IF (SELECT [Revision] FROM [ClicxoftDatabaseRevison] WHERE [ProductId] = 15) IS NULL
BEGIN
	INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (1501, 15, '2016.10.15')
END