﻿/****** Object:  Table [dbo].[ServiceErrorReportingFile]    Script Date: 08/04/2014 11:10:01 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceErrorReportingFile](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[timestamp] [timestamp] NOT NULL,
	[AvatarId] [int] NULL,
	[Name] [nvarchar](80) NULL,
	[TaxYearId] [int] NULL,
	[CurrentCounter] [int] NULL,
	[VoucherSign] [nvarchar](32) NULL,
 CONSTRAINT [pServiceErrorReportingFile] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[ServiceErrorReportingFile]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingFileAvatar] FOREIGN KEY([AvatarId])
REFERENCES [dbo].[Avatar] ([Id])
ON DELETE CASCADE

ALTER TABLE [dbo].[ServiceErrorReportingFile] CHECK CONSTRAINT [fServiceErrorReportingFileAvatar]

ALTER TABLE [dbo].[ServiceErrorReportingFile]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingFileTaxYear] FOREIGN KEY([TaxYearId])
REFERENCES [dbo].[TaxYear] ([Id])

ALTER TABLE [dbo].[ServiceErrorReportingFile] CHECK CONSTRAINT [fServiceErrorReportingFileTaxYear]



/****** Object:  Table [dbo].[ServiceWorksheetFile]    Script Date: 08/04/2014 15:51:09 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceWorksheetFile](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[timestamp] [timestamp] NOT NULL,
	[AvatarId] [int] NULL,
	[Name] [nvarchar](80) NULL,
	[TaxYearId] [int] NULL,
	[CurrentCounter] [int] NULL,
	[VoucherSign] [nvarchar](32) NULL,
	[InvoiceFileId] [int] NULL,
	[ExtraDataCategoryId] [int] NULL,
 CONSTRAINT [pServiceWorksheetFile] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ServiceWorksheetFile]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetFileAvatar] FOREIGN KEY([AvatarId])
REFERENCES [dbo].[Avatar] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ServiceWorksheetFile] CHECK CONSTRAINT [fServiceWorksheetFileAvatar]

ALTER TABLE [dbo].[ServiceWorksheetFile]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetFileExtraDataCategory] FOREIGN KEY([ExtraDataCategoryId])
REFERENCES [dbo].[ExtraDataCategory] ([Id])
ALTER TABLE [dbo].[ServiceWorksheetFile] CHECK CONSTRAINT [fServiceWorksheetFileExtraDataCategory]

ALTER TABLE [dbo].[ServiceWorksheetFile]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetFileTaxYear] FOREIGN KEY([TaxYearId])
REFERENCES [dbo].[TaxYear] ([Id])
ALTER TABLE [dbo].[ServiceWorksheetFile] CHECK CONSTRAINT [fServiceWorksheetFileTaxYear]



/****** Object:  Table [dbo].[ServiceMessage]    Script Date: 08/17/2014 14:05:58 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceMessage](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[MessageText] [nvarchar](max) NOT NULL,
 CONSTRAINT [pServiceMessage] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[ServiceAccessory]    Script Date: 08/04/2014 13:23:41 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceAccessory](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](80) NOT NULL,
 CONSTRAINT [pServiceAccessory] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[ServiceErrorType]    Script Date: 08/07/2014 15:42:13 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceErrorType](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](80) NOT NULL,
 CONSTRAINT [pServiceErrorType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]




/****** Object:  Table [dbo].[ServiceProcessStatus]    Script Date: 08/04/2014 13:26:40 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceProcessStatus](
	[Id] [int] NOT NULL,
	[IsSms] [bit] NOT NULL CONSTRAINT [DF_ServiceProcessStatus_IsSms]  DEFAULT ((0)),
	[IsEmail] [bit] NOT NULL CONSTRAINT [DF_ServiceProcessStatus_IsEmail]  DEFAULT ((0)),
	[MessageText] [text] NULL,
 CONSTRAINT [pServiceProcessStatus] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

INSERT INTO [dbo].[ServiceProcessStatus] (Id, IsSms, IsEmail) VALUES (1, 0, 0)
INSERT INTO [dbo].[ServiceProcessStatus] (Id, IsSms, IsEmail) VALUES (2, 0, 0)
INSERT INTO [dbo].[ServiceProcessStatus] (Id, IsSms, IsEmail) VALUES (3, 0, 0)
INSERT INTO [dbo].[ServiceProcessStatus] (Id, IsSms, IsEmail) VALUES (4, 0, 0)
INSERT INTO [dbo].[ServiceProcessStatus] (Id, IsSms, IsEmail) VALUES (5, 0, 0)
INSERT INTO [dbo].[ServiceProcessStatus] (Id, IsSms, IsEmail) VALUES (6, 0, 0)
INSERT INTO [dbo].[ServiceProcessStatus] (Id, IsSms, IsEmail) VALUES (7, 0, 0)
INSERT INTO [dbo].[ServiceProcessStatus] (Id, IsSms, IsEmail) VALUES (8, 0, 0)
INSERT INTO [dbo].[ServiceProcessStatus] (Id, IsSms, IsEmail) VALUES (9, 0, 0)
INSERT INTO [dbo].[ServiceProcessStatus] (Id, IsSms, IsEmail) VALUES (10, 0, 0)



/****** Object:  Table [dbo].[ServiceSettings]    Script Date: 08/25/2014 18:23:41 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceSettings](
	[Id] [int] NOT NULL,
	[MaterialCostPercent] [decimal](18, 2) NULL,
	[MaterialCostAlways] [bit] NULL CONSTRAINT [DF_ServiceSettings_MaterialCostAlways]  DEFAULT ((0)),
	[TaxId] [int] NULL,
	[IsInvoiced] [bit] NOT NULL CONSTRAINT [DF_ServiceSettings_IsInvoiced]  DEFAULT ((0)),
	[IsStockMove] [bit] NOT NULL CONSTRAINT [DF_ServiceSettings_IsStockMove]  DEFAULT ((0)),
	[PhoneChannelId] [int] NULL,
	[EmailChannelId] [int] NULL,
	[SmsChannelId] [int] NULL,
	[ClientNoId] [int] NULL,
	[PriceTypeId] [int] NULL,
	[GsmModemPort] [nvarchar](16) COLLATE Hungarian_CI_AS NULL,
	[StorageTicketAnnouncement] [nvarchar](max) NULL,
	[WorksheetAnnouncement] [nvarchar](max) NULL,
	[IsPercentWorker] [bit] NOT NULL CONSTRAINT [DF_ServiceSettings_IsPercentWorker]  DEFAULT ((0)),
	[IsMoreWorker] [bit] NOT NULL CONSTRAINT [DF_ServiceSettings_IsMoreWorker]  DEFAULT ((0)),
	[WorkerExitPercent] [decimal](18, 2) NULL,
	[WorkerProductPercent] [decimal](18, 2) NULL,
	[WorkerWorkPhasePercent] [decimal](18, 2) NULL,
	[PartNoId] [int] NULL,
	[Logo] [varbinary](max) NULL,
 CONSTRAINT [PK_ServiceSettings] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[ServiceSettings]  WITH CHECK ADD  CONSTRAINT [fServiceSettingsChannel1] FOREIGN KEY([PhoneChannelId])
REFERENCES [dbo].[Channel] ([Id])

ALTER TABLE [dbo].[ServiceSettings] CHECK CONSTRAINT [fServiceSettingsChannel1]

ALTER TABLE [dbo].[ServiceSettings]  WITH CHECK ADD  CONSTRAINT [fServiceSettingsChannel2] FOREIGN KEY([SmsChannelId])
REFERENCES [dbo].[Channel] ([Id])

ALTER TABLE [dbo].[ServiceSettings] CHECK CONSTRAINT [fServiceSettingsChannel2]

ALTER TABLE [dbo].[ServiceSettings]  WITH CHECK ADD  CONSTRAINT [fServiceSettingsChannel3] FOREIGN KEY([EmailChannelId])
REFERENCES [dbo].[Channel] ([Id])

ALTER TABLE [dbo].[ServiceSettings] CHECK CONSTRAINT [fServiceSettingsChannel3]

ALTER TABLE [dbo].[ServiceSettings]  WITH CHECK ADD  CONSTRAINT [fServiceSettingsClientNo] FOREIGN KEY([ClientNoId])
REFERENCES [dbo].[ClientNo] ([Id])

ALTER TABLE [dbo].[ServiceSettings] CHECK CONSTRAINT [fServiceSettingsClientNo]

ALTER TABLE [dbo].[ServiceSettings]  WITH CHECK ADD  CONSTRAINT [fServiceSettingsPartNo] FOREIGN KEY([PartNoId])
REFERENCES [dbo].[PartNo] ([Id])

ALTER TABLE [dbo].[ServiceSettings] CHECK CONSTRAINT [fServiceSettingsPartNo]

ALTER TABLE [dbo].[ServiceSettings]  WITH CHECK ADD  CONSTRAINT [fServiceSettingsPriceType] FOREIGN KEY([PriceTypeId])
REFERENCES [dbo].[PriceType] ([Id])

ALTER TABLE [dbo].[ServiceSettings] CHECK CONSTRAINT [fServiceSettingsPriceType]

ALTER TABLE [dbo].[ServiceSettings]  WITH CHECK ADD  CONSTRAINT [fServiceSettingsTax] FOREIGN KEY([TaxId])
REFERENCES [dbo].[Tax] ([Id])

ALTER TABLE [dbo].[ServiceSettings] CHECK CONSTRAINT [fServiceSettingsTax]



/***** Egyetlen sor beszúrása *****/
INSERT INTO [dbo].[ServiceSettings] (Id, IsInvoiced, IsStockMove, IsPercentWorker, IsMoreWorker) VALUES (1, 0, 0, 0, 1)




/****** Object:  Table [dbo].[ServiceWorker]    Script Date: 08/04/2014 14:48:15 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceWorker](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](80) NOT NULL,
	[NickName] [nvarchar](32) NOT NULL,
	[CalendarColor] [int] NULL,
 CONSTRAINT [pServiceWorker] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


/****** Object:  Table [dbo].[ServiceDeviceType]    Script Date: 08/04/2014 14:57:54 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceDeviceType](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NULL,
 CONSTRAINT [pServiceDeviceType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


/****** Object:  Table [dbo].[IrisCode]    Script Date: 08/04/2014 14:59:34 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[IrisCode](
	[Code] [nvarchar](8) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
 CONSTRAINT [pIrisCode] PRIMARY KEY CLUSTERED 
(
	[Code] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


/****** Object:  Table [dbo].[ServiceDistributor]    Script Date: 08/04/2014 15:01:36 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceDistributor](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](80) NOT NULL,
 CONSTRAINT [pServiceDistributor] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[ServiceErrorReporting]    Script Date: 08/04/2014 11:10:01 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceErrorReporting](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[timestamp] [timestamp] NOT NULL,
	[AvatarId] [int] NULL,
	[ServiceErrorReportingFileId] [int] NOT NULL,
	[ServiceDeviceTypeId] [int] NULL,
	[PartnerId] [int] NULL,
	[ServiceWorkerId] [int] NULL,
	[ManufacturerId] [int] NULL,
	[ServiceDistributorId] [int] NULL,
	[PriceTypeId] [int] NULL,
	[ContactId] [int] NULL,
	[OrdinalNumber] [int] NOT NULL,
	[VoucherNum] [nvarchar](50) NOT NULL,
	[ProcessStatus] [int] NOT NULL,
	[ZipCode] [nvarchar](21) NOT NULL,
	[PartnerName] [nvarchar](80) NOT NULL,
	[City] [nvarchar](128) NOT NULL,
	[Street] [nvarchar](128) NOT NULL,
	[Phone] [nvarchar](50) NOT NULL,
	[SmsPhone] [nvarchar](50) NULL,
	[Email] [nvarchar](50) NULL,
	[ProductType] [nvarchar](50) NULL,
	[SerialNumber] [nvarchar](50) NULL,
	[AnnouncingDate] [datetime] NOT NULL,
	[VoucherDate] [datetime] NOT NULL,
	[ExitTime] [datetime] NULL,
	[Accessories] [nvarchar](max) NULL,
	[DescriptionOfError] [nvarchar](max) NOT NULL,
	[Note] [nvarchar](max) NULL,
	[IsWarranty] [bit] NOT NULL CONSTRAINT [DF_ServiceErrorReporting_IsWarranty]  DEFAULT ((0)),
	[IsIndoor] [bit] NOT NULL CONSTRAINT [DF_ServiceErrorReporting_IsIndoor]  DEFAULT ((0)),
	[IsOffer] [bit] NOT NULL CONSTRAINT [DF_ServiceErrorReporting_IsOffer]  DEFAULT ((0)),
 CONSTRAINT [pServiceErrorReporting] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[ServiceErrorReporting]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingAvatar] FOREIGN KEY([AvatarId])
REFERENCES [dbo].[Avatar] ([Id])
ON DELETE CASCADE

ALTER TABLE [dbo].[ServiceErrorReporting] CHECK CONSTRAINT [fServiceErrorReportingAvatar]

ALTER TABLE [dbo].[ServiceErrorReporting]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingContact] FOREIGN KEY([ContactId])
REFERENCES [dbo].[Contact] ([Id])

ALTER TABLE [dbo].[ServiceErrorReporting] CHECK CONSTRAINT [fServiceErrorReportingContact]

ALTER TABLE [dbo].[ServiceErrorReporting]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingManufacturer] FOREIGN KEY([ManufacturerId])
REFERENCES [dbo].[Manufacturer] ([Id])

ALTER TABLE [dbo].[ServiceErrorReporting] CHECK CONSTRAINT [fServiceErrorReportingManufacturer]

ALTER TABLE [dbo].[ServiceErrorReporting]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingPartner] FOREIGN KEY([PartnerId])
REFERENCES [dbo].[Partner] ([Id])

ALTER TABLE [dbo].[ServiceErrorReporting] CHECK CONSTRAINT [fServiceErrorReportingPartner]

ALTER TABLE [dbo].[ServiceErrorReporting]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingPriceType] FOREIGN KEY([PriceTypeId])
REFERENCES [dbo].[PriceType] ([Id])

ALTER TABLE [dbo].[ServiceErrorReporting] CHECK CONSTRAINT [fServiceErrorReportingPriceType]

ALTER TABLE [dbo].[ServiceErrorReporting]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingServiceDeviceType] FOREIGN KEY([ServiceDeviceTypeId])
REFERENCES [dbo].[ServiceDeviceType] ([Id])

ALTER TABLE [dbo].[ServiceErrorReporting] CHECK CONSTRAINT [fServiceErrorReportingServiceDeviceType]

ALTER TABLE [dbo].[ServiceErrorReporting]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingServiceDistributor] FOREIGN KEY([ServiceDistributorId])
REFERENCES [dbo].[ServiceDistributor] ([Id])

ALTER TABLE [dbo].[ServiceErrorReporting] CHECK CONSTRAINT [fServiceErrorReportingServiceDistributor]

ALTER TABLE [dbo].[ServiceErrorReporting]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingServiceErrorReportingFile] FOREIGN KEY([ServiceErrorReportingFileId])
REFERENCES [dbo].[ServiceErrorReportingFile] ([Id])

ALTER TABLE [dbo].[ServiceErrorReporting] CHECK CONSTRAINT [fServiceErrorReportingServiceErrorReportingFile]

ALTER TABLE [dbo].[ServiceErrorReporting]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingServiceWorker] FOREIGN KEY([ServiceWorkerId])
REFERENCES [dbo].[ServiceWorker] ([Id])

ALTER TABLE [dbo].[ServiceErrorReporting] CHECK CONSTRAINT [fServiceErrorReportingServiceWorker]


/****** Object:  Table [dbo].[ServiceWarranty]    Script Date: 08/04/2014 16:06:39 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceWarranty](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[IrisCodeCode] [nvarchar](8) NULL,
	[ServiceDistributorId] [int] NULL,
	[DateOfIssue] [datetime] NULL,
	[DateOfValid] [datetime] NULL,
	[DeviceType] [nvarchar](50) NULL,
	[SerialNumber] [nvarchar](50) NULL,
	[WarrantyNumber] [nvarchar](50) NULL,
	[AuthorizationCode] [nvarchar](50) NULL,
 CONSTRAINT [pServiceWarranty] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[ServiceWarranty]  WITH CHECK ADD  CONSTRAINT [fServiceWarrantyIrisCode] FOREIGN KEY([IrisCodeCode])
REFERENCES [dbo].[IrisCode] ([Code])

ALTER TABLE [dbo].[ServiceWarranty] CHECK CONSTRAINT [fServiceWarrantyIrisCode]

ALTER TABLE [dbo].[ServiceWarranty]  WITH CHECK ADD  CONSTRAINT [fServiceWarrantyServiceDistributor] FOREIGN KEY([ServiceDistributorId])
REFERENCES [dbo].[ServiceDistributor] ([Id])

ALTER TABLE [dbo].[ServiceWarranty] CHECK CONSTRAINT [fServiceWarrantyServiceDistributor]


/****** Object:  Table [dbo].[ServiceWorksheet]    Script Date: 08/04/2014 11:10:01 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceWorksheet](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[timestamp] [timestamp] NOT NULL,
	[AvatarId] [int] NULL,
	[ServiceDeviceTypeId] [int] NULL,
	[ServiceWorksheetFileId] [int] NOT NULL,
	[PriceTypeId] [int] NULL,
	[ManufacturerId] [int] NULL,
	[ServiceDistributorId] [int] NULL,
	[ServiceWorkerId] [int] NULL,
	[PartnerId] [int] NULL,
	[ContactId] [int] NULL,
	[PaymentId] [int] NULL,
	[OrdinalNumber] [int] NOT NULL,
	[VoucherNum] [nvarchar](50) NOT NULL,
	[WorksheetStatus] [int] NOT NULL,
	[ProcessStatus] [int] NOT NULL,
	[TypeId] [int] NOT NULL,
	[PartnerName] [nvarchar](80) NOT NULL,
	[ZipCode] [nvarchar](21) NOT NULL,
	[City] [nvarchar](128) NOT NULL,
	[Street] [nvarchar](128) NOT NULL,
	[Phone] [nvarchar](50) NOT NULL,
	[SmsPhone] [nvarchar](50) NULL,
	[Email] [nvarchar](50) NULL,
	[ProductType] [nvarchar](50) NULL,
	[SerialNumber] [nvarchar](50) NULL,
	[VoucherDate] [datetime] NOT NULL,
	[AnnouncingDate] [datetime] NULL,
	[ExitTime] [datetime] NULL,
	[ExitTimeEnd] [datetime] NULL,
	[DeadLine] [datetime] NULL,
	[DescriptionOfError] [nvarchar](max) NULL,
	[Note] [nvarchar](max) NULL,
	[Accessory] [nvarchar](max) NULL,
	[MaxPrice] [decimal](18, 2) NULL,
	[Deposit] [decimal](18, 2) NULL,
	[InvoiceAvatarId] [int] NULL,
	[SumNettoValue] [decimal](18, 2) NULL,
	[SumVatValue] [decimal](18, 2) NULL,
	[SumBruttoValue] [decimal](18, 2) NULL,
	[IsWarranty] [bit] NOT NULL CONSTRAINT [DF_ServiceWorksheet_IsWarranty]  DEFAULT ((0)),
	[IsIndoor] [bit] NOT NULL CONSTRAINT [DF_ServiceWorksheet_IsIndoor]  DEFAULT ((0)),
	[IsPartBack] [bit] NOT NULL CONSTRAINT [DF_ServiceWorksheet_IsPartBack]  DEFAULT ((0)),
	[IsOffer] [bit] NOT NULL CONSTRAINT [DF_ServiceWorksheet_IsOffer]  DEFAULT ((0)),
	[WorkingCity] [nvarchar](128) NULL,
	[WorkingZipCode] [nvarchar](21) NULL,
	[WorkingStreet] [nvarchar](128) NULL,
 CONSTRAINT [pServiceWorksheet] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[ServiceWorksheet]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetContact] FOREIGN KEY([ContactId])
REFERENCES [dbo].[Contact] ([Id])

ALTER TABLE [dbo].[ServiceWorksheet] CHECK CONSTRAINT [fServiceWorksheetContact]

ALTER TABLE [dbo].[ServiceWorksheet]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetManufacturer] FOREIGN KEY([ManufacturerId])
REFERENCES [dbo].[Manufacturer] ([Id])

ALTER TABLE [dbo].[ServiceWorksheet] CHECK CONSTRAINT [fServiceWorksheetManufacturer]

ALTER TABLE [dbo].[ServiceWorksheet]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetPartner] FOREIGN KEY([PartnerId])
REFERENCES [dbo].[Partner] ([Id])

ALTER TABLE [dbo].[ServiceWorksheet] CHECK CONSTRAINT [fServiceWorksheetPartner]

ALTER TABLE [dbo].[ServiceWorksheet]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetPriceType] FOREIGN KEY([PriceTypeId])
REFERENCES [dbo].[PriceType] ([Id])

ALTER TABLE [dbo].[ServiceWorksheet] CHECK CONSTRAINT [fServiceWorksheetPriceType]

ALTER TABLE [dbo].[ServiceWorksheet]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetPayment] FOREIGN KEY([PaymentId])
REFERENCES [dbo].[Payment] ([Id])

ALTER TABLE [dbo].[ServiceWorksheet] CHECK CONSTRAINT [fServiceWorksheetPayment]

ALTER TABLE [dbo].[ServiceWorksheet]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetServiceDeviceType] FOREIGN KEY([ServiceDeviceTypeId])
REFERENCES [dbo].[ServiceDeviceType] ([Id])

ALTER TABLE [dbo].[ServiceWorksheet] CHECK CONSTRAINT [fServiceWorksheetServiceDeviceType]

ALTER TABLE [dbo].[ServiceWorksheet]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetServiceDistributor] FOREIGN KEY([ServiceDistributorId])
REFERENCES [dbo].[ServiceDistributor] ([Id])

ALTER TABLE [dbo].[ServiceWorksheet] CHECK CONSTRAINT [fServiceWorksheetServiceDistributor]

ALTER TABLE [dbo].[ServiceWorksheet]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetServiceWorker] FOREIGN KEY([ServiceWorkerId])
REFERENCES [dbo].[ServiceWorker] ([Id])

ALTER TABLE [dbo].[ServiceWorksheet] CHECK CONSTRAINT [fServiceWorksheetServiceWorker]

ALTER TABLE [dbo].[ServiceWorksheet]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetServiceWorksheetFile] FOREIGN KEY([ServiceWorksheetFileId])
REFERENCES [dbo].[ServiceWorksheetFile] ([Id])

ALTER TABLE [dbo].[ServiceWorksheet] CHECK CONSTRAINT [fServiceWorksheetServiceWorksheetFile]



/****** Object:  Table [dbo].[ServiceWorksheetItem]    Script Date: 08/14/2014 07:46:59 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceWorksheetItem](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ServiceWorksheetId] [int] NOT NULL,
	[ServiceWorkerId] [int] NULL,
	[ProductId] [int] NULL,
	[Name] [nvarchar](80) NOT NULL,
	[ItemDate] [datetime] NOT NULL,
	[Quantity] [decimal](18, 2) NULL,
	[MeasureUnit] [nvarchar](8) NULL,
	[UnitPrice] [decimal](18, 2) NULL,
	[TaxId] [int] NULL,
	[NettoAmount] [decimal](18, 2) NULL,
	[BruttoAmount] [decimal](18, 2) NULL,
	[ProductIdentifier] [nvarchar](128) NULL,
	[Note] [nvarchar](max) NULL,
	[IsSms] [bit] NOT NULL CONSTRAINT [DF_ServiceWorksheetItem_IsWarranty]  DEFAULT ((0)),
	[IsEmail] [bit] NOT NULL CONSTRAINT [DF_ServiceWorksheetItem_IsOffer]  DEFAULT ((0)),
	[IsToBill] [bit] NOT NULL CONSTRAINT [DF_ServiceWorksheetItem_IsIndoor]  DEFAULT ((0)),
	[Percent] [decimal](18, 2) NULL,
 CONSTRAINT [pServiceWorksheetItem] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[ServiceWorksheetItem]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetItemProduct] FOREIGN KEY([ProductId])
REFERENCES [dbo].[Product] ([Id])

ALTER TABLE [dbo].[ServiceWorksheetItem] CHECK CONSTRAINT [fServiceWorksheetItemProduct]

ALTER TABLE [dbo].[ServiceWorksheetItem]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetItemServiceWorker] FOREIGN KEY([ServiceWorkerId])
REFERENCES [dbo].[ServiceWorker] ([Id])

ALTER TABLE [dbo].[ServiceWorksheetItem] CHECK CONSTRAINT [fServiceWorksheetItemServiceWorker]

ALTER TABLE [dbo].[ServiceWorksheetItem]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetItemServiceWorksheet] FOREIGN KEY([ServiceWorksheetId])
REFERENCES [dbo].[ServiceWorksheet] ([Id])
ON UPDATE CASCADE
ON DELETE CASCADE

ALTER TABLE [dbo].[ServiceWorksheetItem] CHECK CONSTRAINT [fServiceWorksheetItemServiceWorksheet]

ALTER TABLE [dbo].[ServiceWorksheetItem]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetItemTax] FOREIGN KEY([TaxId])
REFERENCES [dbo].[Tax] ([Id])

ALTER TABLE [dbo].[ServiceWorksheetItem] CHECK CONSTRAINT [fServiceWorksheetItemTax]




/****** Object:  Table [dbo].[ServiceEvent]    Script Date: 08/04/2014 13:25:32 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceEvent](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](128) NULL,
	[EventDate] [datetime] NOT NULL,
	[ProcessStatusId] [int] NULL,
	[ServiceWorksheetId] [int] NOT NULL,
	[IsGenerated] [bit] NOT NULL CONSTRAINT [DF_ServiceEvent_IsGenerated]  DEFAULT ((0)),
	[IsSms] [bit] NOT NULL CONSTRAINT [DF_ServiceEvent_IsSms]  DEFAULT ((0)),
	[IsEmail] [bit] NOT NULL CONSTRAINT [DF_ServiceEvent_IsEmail]  DEFAULT ((0)),
	[Message] [nvarchar](max) NULL,
 CONSTRAINT [pServiceEvent] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ServiceEvent]  WITH CHECK ADD  CONSTRAINT [fServiceEventServiceWorksheet] FOREIGN KEY([ServiceWorksheetId])
REFERENCES [dbo].[ServiceWorksheet] ([Id])

ALTER TABLE [dbo].[ServiceEvent] CHECK CONSTRAINT [fServiceEventServiceWorksheet]




/****** Object:  Table [dbo].[ServiceErrorReportingServiceWarranty]    Script Date: 08/10/2014 09:53:35 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceErrorReportingServiceWarranty](
	[ServiceErrorReportingId] [int] NOT NULL,
	[ServiceWarrantyId] [int] NOT NULL,
 CONSTRAINT [pServiceErrorReportingServiceWarranty] PRIMARY KEY CLUSTERED 
(
	[ServiceErrorReportingId] ASC,
	[ServiceWarrantyId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[ServiceErrorReportingServiceWarranty]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingServiceErrorReportingServiceWarranty] FOREIGN KEY([ServiceErrorReportingId])
REFERENCES [dbo].[ServiceErrorReporting] ([Id])

ALTER TABLE [dbo].[ServiceErrorReportingServiceWarranty] CHECK CONSTRAINT [fServiceErrorReportingServiceErrorReportingServiceWarranty]

ALTER TABLE [dbo].[ServiceErrorReportingServiceWarranty]  WITH CHECK ADD  CONSTRAINT [fServiceWarrantyServiceErrorReportingServiceWarranty] FOREIGN KEY([ServiceWarrantyId])
REFERENCES [dbo].[ServiceWarranty] ([Id])

ALTER TABLE [dbo].[ServiceErrorReportingServiceWarranty] CHECK CONSTRAINT [fServiceWarrantyServiceErrorReportingServiceWarranty]



/****** Object:  Table [dbo].[ServiceWorksheetServiceWarranty]    Script Date: 08/10/2014 10:07:13 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceWorksheetServiceWarranty](
	[ServiceWorksheetId] [int] NOT NULL,
	[ServiceWarrantyId] [int] NOT NULL,
 CONSTRAINT [PK_ServiceWorksheetServiceWarranty] PRIMARY KEY CLUSTERED 
(
	[ServiceWorksheetId] ASC,
	[ServiceWarrantyId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[ServiceWorksheetServiceWarranty]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetServiceWarrantyServiceWarranty] FOREIGN KEY([ServiceWarrantyId])
REFERENCES [dbo].[ServiceWarranty] ([Id])

ALTER TABLE [dbo].[ServiceWorksheetServiceWarranty] CHECK CONSTRAINT [fServiceWorksheetServiceWarrantyServiceWarranty]

ALTER TABLE [dbo].[ServiceWorksheetServiceWarranty]  WITH CHECK ADD  CONSTRAINT [fServiceWorksheetServiceWarrantyServiceWorksheet] FOREIGN KEY([ServiceWorksheetId])
REFERENCES [dbo].[ServiceWorksheet] ([Id])

ALTER TABLE [dbo].[ServiceWorksheetServiceWarranty] CHECK CONSTRAINT [fServiceWorksheetServiceWarrantyServiceWorksheet]




/****** Object:  Table [dbo].[ServiceErrorReportingServiceWorksheet]    Script Date: 08/09/2014 07:09:14 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceErrorReportingServiceWorksheet](
	[ServiceErrorReportingId] [int] NOT NULL,
	[ServiceWorksheetId] [int] NOT NULL,
 CONSTRAINT [PK_ServiceErrorReportingServiceWorksheet] PRIMARY KEY CLUSTERED 
(
	[ServiceErrorReportingId] ASC,
	[ServiceWorksheetId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[ServiceErrorReportingServiceWorksheet]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingServiceWorksheetServiceErrorReporting] FOREIGN KEY([ServiceErrorReportingId])
REFERENCES [dbo].[ServiceErrorReporting] ([Id])

ALTER TABLE [dbo].[ServiceErrorReportingServiceWorksheet] CHECK CONSTRAINT [fServiceErrorReportingServiceWorksheetServiceErrorReporting]

ALTER TABLE [dbo].[ServiceErrorReportingServiceWorksheet]  WITH CHECK ADD  CONSTRAINT [fServiceErrorReportingServiceWorksheetServiceWorksheet] FOREIGN KEY([ServiceWorksheetId])
REFERENCES [dbo].[ServiceWorksheet] ([Id])

ALTER TABLE [dbo].[ServiceErrorReportingServiceWorksheet] CHECK CONSTRAINT [fServiceErrorReportingServiceWorksheetServiceWorksheet]



/****** Object:  Table [dbo].[ServiceCalendar]    Script Date: 09/07/2014 09:47:32 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceCalendar](
	[Identifier] [uniqueidentifier] NOT NULL,
	[StarDateTime] [datetime] NOT NULL,
	[ServiceWorkerId] [int] NOT NULL,
	[EndDateTime] [datetime] NOT NULL,
	[Description] [nvarchar](max) NOT NULL,
	[BackGroundColor] [int] NULL,
	[WorksheetId] [int] NULL,
 CONSTRAINT [PK_ServiceCalendar] PRIMARY KEY CLUSTERED 
(
	[StarDateTime] ASC,
	[ServiceWorkerId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[ServiceCalendar]  WITH CHECK ADD  CONSTRAINT [fServiceCalendarServiceWorker] FOREIGN KEY([ServiceWorkerId])
REFERENCES [dbo].[ServiceWorker] ([Id])

ALTER TABLE [dbo].[ServiceCalendar] CHECK CONSTRAINT [fServiceCalendarServiceWorker]




/****** Object:  Table [dbo].[ServiceSms]    Script Date: 09/16/2014 11:39:10 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[ServiceSms](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[PhoneNumber] [nvarchar](16) NOT NULL,
	[Message] [nvarchar](max) NOT NULL,
	[SendingDate] [datetime] NOT NULL,
	[ContoUserId] [int] NOT NULL,
	[PartnerId] [int] NOT NULL,
 CONSTRAINT [pServiceSms] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[ServiceSms]  WITH CHECK ADD  CONSTRAINT [fServiceSmsContoUser] FOREIGN KEY([ContoUserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[ServiceSms] CHECK CONSTRAINT [fServiceSmsContoUser]




/****** Object:  Table [dbo].[SystemDefault]    Script Date: 05/01/2014 09:55:40 ******/
ALTER TABLE [dbo].[SystemDefault] ADD [CheckingAccountClientNo] [int] NULL
ALTER TABLE [dbo].[SystemDefault] ADD [CheckingAccountEmail] [int] NULL
ALTER TABLE [dbo].[SystemDefault] ADD [CheckingAccountMobilSms] [int] NULL


/****** Object:  Table [dbo].[TableType]    Script Date: 08/04/2014 09:55:40 ******/
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (920, 'ServiceWorksheetFile', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (921, 'ServiceWorksheet', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (922, 'ServiceWorksheetItem', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (923, 'ServiceErrorReportingFile', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (924, 'ServiceErrorReporting', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (925, 'ServiceProcessStatus', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (926, 'ServiceSettings', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (927, 'ServiceEvent', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (928, 'ServiceMessage', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (929, 'ServiceWorker', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (930, 'ServiceWarranty', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (931, 'ServiceDeviceType', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (932, 'IrisCode', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (933, 'ServiceDistributor', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (934, 'ServiceAccessory', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (935, 'ServiceErrorType', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (936, 'ServiceErrorReportingServiceWarranty', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (937, 'ServiceErrorReportingServiceWorksheet', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (938, 'ServiceWorksheetServiceWarranty', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (939, 'ServiceCalendar', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (940, 'ServiceSms', 0, 0)





/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 01/04/2015 21:26:52 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ClicxoftDatabaseRevison]') AND type in (N'U'))
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	CREATE TABLE [dbo].[ClicxoftDatabaseRevison](
		[Revision] [int] NOT NULL,
		[ProductId] [int] NOT NULL,
		[Performed] [datetime] NOT NULL,
	 CONSTRAINT [pClicxoftDatabaseRevison] PRIMARY KEY CLUSTERED 
	(
		[Revision] ASC,
		[ProductId] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1000, 'ClicxoftDatabaseRevison', 0, 0)
END

IF (SELECT [Revision] FROM [ClicxoftDatabaseRevison] WHERE [ProductId] = 1) IS NULL
BEGIN
	INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (201401, 1, '2014.01.01')
END

IF (SELECT [Revision] FROM [ClicxoftDatabaseRevison] WHERE [ProductId] = 4) IS NULL
BEGIN
	INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (201401, 4, '2014.01.01')
END
