﻿/****** Object:  Table [dbo].[HrAbsenceType]    Script Date: 2019.01.07. 13:19:29 ******/
CREATE TABLE [dbo].[HrAbsenceType](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[MessageText] [nvarchar](max) NULL,
 CONSTRAINT [PK_HrAbsenceType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


/****** Object:  Table [dbo].[HrApplyType]    Script Date: 2019.01.07. 13:20:17 ******/
CREATE TABLE [dbo].[HrApplyType](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [varchar](50) NOT NULL,
 CONSTRAINT [PK_HrApplyType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


/****** Object:  Table [dbo].[HrEducationType]    Script Date: 2019.01.07. 13:21:10 ******/
CREATE TABLE [dbo].[HrEducationType](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [varchar](50) NOT NULL,
 CONSTRAINT [PK_HrEducationType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[HrEventType]    Script Date: 2019.01.07. 13:22:06 ******/
CREATE TABLE [dbo].[HrEventType](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [varchar](50) NOT NULL,
 CONSTRAINT [PK_HrEventType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[HrJob]    Script Date: 2019.01.07. 13:22:56 ******/
CREATE TABLE [dbo].[HrJob](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [varchar](50) NOT NULL,
 CONSTRAINT [PK_HrJob] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[HrMsgCategory]    Script Date: 2019.01.07. 13:23:29 ******/
CREATE TABLE [dbo].[HrMsgCategory](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_HrMsgCategory] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[HrPreStatus]    Script Date: 2019.01.07. 13:24:12 ******/
CREATE TABLE [dbo].[HrPreStatus](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [varchar](50) NOT NULL,
 CONSTRAINT [PK_HrPreStatus] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[HrWorkPlace]    Script Date: 2019.01.07. 13:25:12 ******/
CREATE TABLE [dbo].[HrWorkPlace](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [varchar](50) NOT NULL,
 CONSTRAINT [PK_HrWorkPlace] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[HrWorkuotDays]    Script Date: 2019.01.07. 13:26:11 ******/
CREATE TABLE [dbo].[HrWorkuotDays](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[CalendarDate] [datetime] NOT NULL,
	[IsHolyday] [bit] NOT NULL CONSTRAINT [DF_HrWorkuotDays_IsHolyday]  DEFAULT ((1)),
	[IsPayable] [bit] NOT NULL CONSTRAINT [DF_HrWorkuotDays_IsPayable]  DEFAULT ((0)),
 CONSTRAINT [PK_HrWorkuotDays] PRIMARY KEY CLUSTERED 
(
	[Id] ASC,
	[CalendarDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[HrEmployStatus]    Script Date: 2019.01.07. 13:35:32 ******/
CREATE TABLE [dbo].[HrEmployStatus](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](30) NOT NULL,
 CONSTRAINT [PK_HrEmployStatus] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]




/****** Object:  Table [dbo].[HrEmployee]    Script Date: 2019.01.07. 13:26:52 ******/
CREATE TABLE [dbo].[HrEmployee](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AvatarId] [int] NULL,
	[IdentNumber] [nvarchar](20) NULL,
	[HrApplyTypeId] [int] NULL,
	[Name] [nvarchar](50) NOT NULL,
	[BirthName] [nvarchar](50) NULL,
	[BirthDay] [datetime] NULL,
	[BirthLocation] [nvarchar](50) NULL,
	[MotherName] [nvarchar](50) NULL,
	[BankAccountNumber] [nvarchar](50) NULL,
	[ApplyDate] [datetime] NOT NULL,
	[HrStatusType] [int] NOT NULL,
	[FamilyStatus] [int] NULL,
	[GenderType] [int] NULL,
	[EmployStatusId] [int] NULL,
	[EmployeePhoto] [varbinary](max) NULL,
	[Note] [nvarchar](max) NULL,
	[Email] [nvarchar](50) NULL,
	[Telephone] [nvarchar](50) NULL,
	[ApplyMethod] [nvarchar](30) NULL,
	[AnnualLeaveDay] [int] NULL,
	[PasswordSalt] [nchar](8) NULL,
	[PasswordHash] [nchar](44) NULL,
	[PasswordMemo] [nvarchar](max) NULL,
	[LoginName] [nvarchar](20) NULL,
	[IsFirstWorkplace] [bit] NOT NULL CONSTRAINT [DF_HrEmployee_IsFirstWprkplace]  DEFAULT ((0)),
	[FormerWorkplace] [nvarchar](50) NULL,
	[VatNumber] [nvarchar](20) NULL,
	[HealthInsuranceNumber] [nvarchar](20) NULL,
 CONSTRAINT [PK_HrEmployee] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
SET ANSI_PADDING OFF
ALTER TABLE [dbo].[HrEmployee]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployee_Avatar] FOREIGN KEY([AvatarId])
REFERENCES [dbo].[Avatar] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrEmployee] CHECK CONSTRAINT [FK_HrEmployee_Avatar]
ALTER TABLE [dbo].[HrEmployee]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployee_HrApplyType] FOREIGN KEY([HrApplyTypeId])
REFERENCES [dbo].[HrApplyType] ([Id])
ALTER TABLE [dbo].[HrEmployee] CHECK CONSTRAINT [FK_HrEmployee_HrApplyType]
ALTER TABLE [dbo].[HrEmployee]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployee_HrEmployStatus] FOREIGN KEY([EmployStatusId])
REFERENCES [dbo].[HrEmployStatus] ([Id])
ALTER TABLE [dbo].[HrEmployee] CHECK CONSTRAINT [FK_HrEmployee_HrEmployStatus]




/****** Object:  Table [dbo].[HrAbsencePlan]    Script Date: 2019.01.07. 13:27:47 ******/
CREATE TABLE [dbo].[HrAbsencePlan](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[FromDate] [datetime] NOT NULL,
	[ToDate] [datetime] NOT NULL,
 CONSTRAINT [PK_HrAbsencePlan] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[HrAbsencePlan]  WITH CHECK ADD  CONSTRAINT [FK_HrAbsencePlan_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrAbsencePlan] CHECK CONSTRAINT [FK_HrAbsencePlan_HrEmployee]



/****** Object:  Table [dbo].[HrEmployeeAbsence]    Script Date: 2019.01.07. 13:28:18 ******/
CREATE TABLE [dbo].[HrEmployeeAbsence](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[HrAbsenceTypeId] [int] NOT NULL,
	[FromDate] [datetime] NOT NULL,
	[ToDate] [datetime] NULL,
	[SumDay] [int] NULL CONSTRAINT [DF_HrEmployeeAbsence_SumDay]  DEFAULT ((0)),
	[IsDraft] [bit] NOT NULL CONSTRAINT [DF_HrEmployeeAbsence_IsDraft]  DEFAULT ((0)),
	[WebNote] [nvarchar](max) NULL,
 CONSTRAINT [PK_HrEmployeeAbsence] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
ALTER TABLE [dbo].[HrEmployeeAbsence]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeAbsence_HrAbsenceType] FOREIGN KEY([HrAbsenceTypeId])
REFERENCES [dbo].[HrAbsenceType] ([Id])
ALTER TABLE [dbo].[HrEmployeeAbsence] CHECK CONSTRAINT [FK_HrEmployeeAbsence_HrAbsenceType]
ALTER TABLE [dbo].[HrEmployeeAbsence]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeAbsence_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrEmployeeAbsence] CHECK CONSTRAINT [FK_HrEmployeeAbsence_HrEmployee]



/****** Object:  Table [dbo].[HrEmployeeAddress]    Script Date: 2019.01.07. 13:29:03 ******/
CREATE TABLE [dbo].[HrEmployeeAddress](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[Zip] [nvarchar](10) NOT NULL,
	[City] [nvarchar](50) NOT NULL,
	[Street] [nvarchar](50) NOT NULL,
	[IsFixed] [bit] NOT NULL CONSTRAINT [DF_Table_1_IsFized]  DEFAULT ((0)),
	[IsClosed] [bit] NOT NULL CONSTRAINT [DF_HrEmployeeAddress_IsClosed]  DEFAULT ((0)),
	[RealAddress] [nvarchar](100) NOT NULL,
 CONSTRAINT [PK_HrEmployeeAddress] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[HrEmployeeAddress]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeAddress_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrEmployeeAddress] CHECK CONSTRAINT [FK_HrEmployeeAddress_HrEmployee]



/****** Object:  Table [dbo].[HrEmployeeChild]    Script Date: 2019.01.07. 13:29:47 ******/
CREATE TABLE [dbo].[HrEmployeeChild](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[BirthDate] [datetime] NULL,
 CONSTRAINT [PK_HrEmployeeChild] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[HrEmployeeChild]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeChild_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrEmployeeChild] CHECK CONSTRAINT [FK_HrEmployeeChild_HrEmployee]



/****** Object:  Table [dbo].[HrEmployeeEducation]    Script Date: 2019.01.07. 13:30:26 ******/
CREATE TABLE [dbo].[HrEmployeeEducation](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[HrEducationId] [int] NOT NULL,
	[FromDate] [datetime] NOT NULL,
	[CertificateNr] [nvarchar](30) NULL,
 CONSTRAINT [PK_HrEmployeeEducation] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[HrEmployeeEducation]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeEducation_HrEducationType] FOREIGN KEY([HrEducationId])
REFERENCES [dbo].[HrEducationType] ([Id])
ALTER TABLE [dbo].[HrEmployeeEducation] CHECK CONSTRAINT [FK_HrEmployeeEducation_HrEducationType]
ALTER TABLE [dbo].[HrEmployeeEducation]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeEducation_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrEmployeeEducation] CHECK CONSTRAINT [FK_HrEmployeeEducation_HrEmployee]



/****** Object:  Table [dbo].[HrEmployeeJob]    Script Date: 2019.01.07. 13:31:25 ******/
CREATE TABLE [dbo].[HrEmployeeJob](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[HrJobId] [int] NOT NULL,
	[FromDate] [datetime] NOT NULL,
	[ToDate] [datetime] NULL,
 CONSTRAINT [PK_HrEmployeeJob] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[HrEmployeeJob]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeJob_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrEmployeeJob] CHECK CONSTRAINT [FK_HrEmployeeJob_HrEmployee]
ALTER TABLE [dbo].[HrEmployeeJob]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeJob_HrJob] FOREIGN KEY([HrJobId])
REFERENCES [dbo].[HrJob] ([Id])
ALTER TABLE [dbo].[HrEmployeeJob] CHECK CONSTRAINT [FK_HrEmployeeJob_HrJob]



/****** Object:  Table [dbo].[HrEmployeeLog]    Script Date: 2019.01.07. 13:32:01 ******/
CREATE TABLE [dbo].[HrEmployeeLog](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[LogDate] [datetime] NOT NULL,
	[LogText] [nvarchar](max) NOT NULL,
 CONSTRAINT [PK_HrEmployeeLog] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
ALTER TABLE [dbo].[HrEmployeeLog]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeLog_ContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[HrEmployeeLog] CHECK CONSTRAINT [FK_HrEmployeeLog_ContoUser]
ALTER TABLE [dbo].[HrEmployeeLog]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeLog_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ALTER TABLE [dbo].[HrEmployeeLog] CHECK CONSTRAINT [FK_HrEmployeeLog_HrEmployee]



/****** Object:  Table [dbo].[HrEmployeeMessage]    Script Date: 2019.01.07. 13:32:48 ******/
CREATE TABLE [dbo].[HrEmployeeMessage](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[HrMsgCategoryId] [int] NOT NULL,
	[Subject] [nvarchar](80) NOT NULL,
	[Message] [nvarchar](max) NOT NULL,
	[Date] [datetime] NOT NULL,
	[IsGenerated] [bit] NOT NULL CONSTRAINT [DF_HrEmployeeMessage_IsGenerated]  DEFAULT ((0)),
	[OpenDate] [datetime] NULL,
	[UserId] [int] NULL,
 CONSTRAINT [PK_HrEmployeeMessage] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
ALTER TABLE [dbo].[HrEmployeeMessage]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeMessage_ContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[HrEmployeeMessage] CHECK CONSTRAINT [FK_HrEmployeeMessage_ContoUser]
ALTER TABLE [dbo].[HrEmployeeMessage]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeMessage_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrEmployeeMessage] CHECK CONSTRAINT [FK_HrEmployeeMessage_HrEmployee]
ALTER TABLE [dbo].[HrEmployeeMessage]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeMessage_HrMsgCategory] FOREIGN KEY([HrMsgCategoryId])
REFERENCES [dbo].[HrMsgCategory] ([Id])
ALTER TABLE [dbo].[HrEmployeeMessage] CHECK CONSTRAINT [FK_HrEmployeeMessage_HrMsgCategory]



/****** Object:  Table [dbo].[HrEmployeePreProcess]    Script Date: 2019.01.07. 13:33:35 ******/
CREATE TABLE [dbo].[HrEmployeePreProcess](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[HrPreStatusId] [int] NOT NULL,
	[FromDate] [datetime] NOT NULL,
	[ToDate] [datetime] NULL,
	[Note] [nvarchar](max) NULL,
 CONSTRAINT [PK_HrEmployeePreProcess] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
ALTER TABLE [dbo].[HrEmployeePreProcess]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeePreProcess_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrEmployeePreProcess] CHECK CONSTRAINT [FK_HrEmployeePreProcess_HrEmployee]
ALTER TABLE [dbo].[HrEmployeePreProcess]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeePreProcess_HrPreStatus] FOREIGN KEY([HrPreStatusId])
REFERENCES [dbo].[HrPreStatus] ([Id])
ALTER TABLE [dbo].[HrEmployeePreProcess] CHECK CONSTRAINT [FK_HrEmployeePreProcess_HrPreStatus]



/****** Object:  Table [dbo].[HrEmployeeSalary]    Script Date: 2019.01.07. 13:34:19 ******/
CREATE TABLE [dbo].[HrEmployeeSalary](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[FromDate] [datetime] NOT NULL,
	[ToDate] [datetime] NULL,
	[Salary] [decimal](18, 2) NOT NULL,
 CONSTRAINT [PK_HrEmployeeSalary] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[HrEmployeeSalary]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeSalary_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrEmployeeSalary] CHECK CONSTRAINT [FK_HrEmployeeSalary_HrEmployee]



/****** Object:  Table [dbo].[HrEmployeeWorkplace]    Script Date: 2019.01.07. 13:34:49 ******/
CREATE TABLE [dbo].[HrEmployeeWorkplace](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[HrWorkPlaceId] [int] NOT NULL,
	[FromDate] [datetime] NOT NULL,
	[ToDate] [datetime] NULL,
 CONSTRAINT [PK_HrEmployeeWorkplace] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[HrEmployeeWorkplace]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeWorkplace_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrEmployeeWorkplace] CHECK CONSTRAINT [FK_HrEmployeeWorkplace_HrEmployee]
ALTER TABLE [dbo].[HrEmployeeWorkplace]  WITH CHECK ADD  CONSTRAINT [FK_HrEmployeeWorkplace_HrWorkPlace] FOREIGN KEY([HrWorkPlaceId])
REFERENCES [dbo].[HrWorkPlace] ([Id])
ALTER TABLE [dbo].[HrEmployeeWorkplace] CHECK CONSTRAINT [FK_HrEmployeeWorkplace_HrWorkPlace]




/****** Object:  Table [dbo].[HrEvent]    Script Date: 2019.01.07. 13:36:38 ******/
CREATE TABLE [dbo].[HrEvent](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NULL,
	[HrEventTypeId] [int] NOT NULL,
	[Date] [datetime] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Note] [varchar](max) NULL,
 CONSTRAINT [PK_HrEvent] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
SET ANSI_PADDING OFF
ALTER TABLE [dbo].[HrEvent]  WITH CHECK ADD  CONSTRAINT [FK_HrEvent_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrEvent] CHECK CONSTRAINT [FK_HrEvent_HrEmployee]
ALTER TABLE [dbo].[HrEvent]  WITH CHECK ADD  CONSTRAINT [FK_HrEvent_HrEventType] FOREIGN KEY([HrEventTypeId])
REFERENCES [dbo].[HrEventType] ([Id])
ALTER TABLE [dbo].[HrEvent] CHECK CONSTRAINT [FK_HrEvent_HrEventType]



/****** Object:  Table [dbo].[HrOvertimeWork]    Script Date: 2019.01.07. 13:37:27 ******/
CREATE TABLE [dbo].[HrOvertimeWork](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[WorkDate] [datetime] NOT NULL,
	[WorkOur] [int] NULL,
	[IsPayable] [bit] NOT NULL CONSTRAINT [DF_HrWeekendWork_IsPayable]  DEFAULT ((0))
) ON [PRIMARY]
ALTER TABLE [dbo].[HrOvertimeWork]  WITH CHECK ADD  CONSTRAINT [FK_HrOvertimeWork_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrOvertimeWork] CHECK CONSTRAINT [FK_HrOvertimeWork_HrEmployee]



/****** Object:  Table [dbo].[HrStatusLog]    Script Date: 2019.01.07. 13:38:04 ******/
CREATE TABLE [dbo].[HrStatusLog](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[OldStatus] [int] NOT NULL,
	[NewStatus] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[ChangeDate] [datetime] NOT NULL,
 CONSTRAINT [PK_HrStatusLog] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[HrStatusLog]  WITH CHECK ADD  CONSTRAINT [FK_HrStatusLog_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrStatusLog] CHECK CONSTRAINT [FK_HrStatusLog_HrEmployee]



/****** Object:  Table [dbo].[HrTask]    Script Date: 2019.01.07. 13:38:46 ******/
CREATE TABLE [dbo].[HrTask](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HrEmployeeId] [int] NOT NULL,
	[Date] [datetime] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Note] [varchar](max) NULL,
	[Deadline] [datetime] NOT NULL,
	[UserId] [int] NULL,
	[IsClosed] [bit] NOT NULL CONSTRAINT [DF_HrTask_IsColsed]  DEFAULT ((0)),
 CONSTRAINT [PK_HrTask] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
SET ANSI_PADDING OFF
ALTER TABLE [dbo].[HrTask]  WITH CHECK ADD  CONSTRAINT [FK_HrTask_ContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[HrTask] CHECK CONSTRAINT [FK_HrTask_ContoUser]
ALTER TABLE [dbo].[HrTask]  WITH CHECK ADD  CONSTRAINT [FK_HrTask_HrEmployee] FOREIGN KEY([HrEmployeeId])
REFERENCES [dbo].[HrEmployee] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[HrTask] CHECK CONSTRAINT [FK_HrTask_HrEmployee]




/****** Szerződés beállítások funkciótér felvétele ******/
INSERT INTO [dbo].[FuncSpace] ([Name], Description, Allowed, TypeId) VALUES ('Clicxoft.Hr.Settings', 'Program beállítások', 'True', 1)
INSERT INTO [dbo].[FuncSpace] ([Name], Description, Allowed, TypeId) VALUES ('Clicxoft.Hr.Admin', 'Teljes hozzáférés', 'True', 1)
INSERT INTO [dbo].[FuncSpace] ([Name], Description, Allowed, TypeId) VALUES ('Clicxoft.Hr.Read', 'Olvasés hozzáférés', 'True', 1)
INSERT INTO [dbo].[FuncSpace] ([Name], Description, Allowed, TypeId) VALUES ('Clicxoft.Hr.Query', 'Lekérdezések hozzáférés', 'True', 1)
INSERT INTO [dbo].[FuncSpace] ([Name], Description, Allowed, TypeId) VALUES ('Clicxoft.Hr.CheckingAnsence', 'Távollét engedélyezés', 'True', 1)


/****** Object:  Table [dbo].[TableType]    Script Date: 08/04/2014 09:55:40 ******/
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1050, 'HrEmployee', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1051, 'HrAbsencePlan', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1052, 'HrAbsenceType', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1053, 'HrApplyType', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1054, 'HrEducationType', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1055, 'HrEmployeeAbsence', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1056, 'HrEmployeeAddress', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1057, 'HrEmployeeChild', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1058, 'HrEmployeeEducation', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1059, 'HrEmployeeJob', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1061, 'HrEmployeeLog', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1062, 'HrEmployeeMessage', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1063, 'HrEmployeePreProcess', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1064, 'HrEmployeeSalary', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1065, 'HrEmployeeWorkplace', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1066, 'HrEmployStatus', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1067, 'HrEvent', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1068, 'HrEventType', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1069, 'HrJob', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1070, 'HrMsgCategory', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1071, 'HrOvertimeWork', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1072, 'HrPreStatus', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1073, 'HrStatusLog', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1074, 'HrTask', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1075, 'HrWorkPlace', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1076, 'HrWorkuotDays', 0, 0)

/******
DECLARE @maxVal INT
SELECT @maxVal = ISNULL(max(Id),0) from Avatar
DBCC CHECKIDENT ('Avatar', RESEED, @maxVal);

SELECT @maxVal = ISNULL(max(Id),0) from Avatar
DBCC CHECKIDENT ('HrEmployee', RESEED, @maxVal);
******/