      CREATE TRIGGER [dbo].[OnUpdateDebitManagementFile]
      ON [dbo].[DebitManagementFile]
      FOR UPDATE AS
      BEGIN
      -- =============================================
      -- Author:		Bokor J. Mrk
      -- Adapted:		dr. Dzsa Andrs
      -- Create date: 2014.08.06
      -- Description:	General insert trigger
      --              to assign avatarId
      -- =============================================
      SET NOCOUNT ON
      --work wariables
      DECLARE @ServiceErrorReportingFilesId Int
      DECLARE @NewAvatarID Int
      --Table Type Detection
      DECLARE @TriggeredTableId Int
      --DataSpace fill variables
      DECLARE @ServiceErrorReportingFilesName nvarchar(50)
      DECLARE @DataSpaceName nvarchar(256)
      DECLARE @DataSpaceDescription nvarchar(80)

      --query our trigger's id
      SELECT @TriggeredTableId = Id FROM TableType WHERE Name = 'DebitManagementFile'

      DECLARE tmpCursor CURSOR LOCAL FOR
      SELECT Inserted.Id, Inserted.AvatarId, Inserted.Name
      FROM Inserted INNER JOIN Deleted ON Inserted.Id = Deleted.Id
      OPEN tmpCursor
      FETCH NEXT FROM tmpCursor INTO @ServiceErrorReportingFilesId, @NewAvatarID, @ServiceErrorReportingFilesName
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
      --Insert DataSpace Entry
      SET @DataSpaceName = CAST(@TriggeredTableId as varchar) + '.' + CAST(@ServiceErrorReportingFilesId as varchar)
      SET @DataSpaceDescription =  'Tartozs llomny:' + @ServiceErrorReportingFilesName
      EXEC sp_SaveToDataSpace @NewAvatarID, @DataSpaceName, @DataSpaceDescription, 2
      -- get next record
      FETCH NEXT FROM tmpCursor INTO @ServiceErrorReportingFilesId, @NewAvatarID, @ServiceErrorReportingFilesName
      END
      CLOSE tmpCursor
      DEALLOCATE tmpCursor
      END