/****** Object:  Table [dbo].[DebitLetterTemplate]    Script Date: 05/18/2015 16:10:57 ******/
CREATE TABLE [dbo].[DebitLetterTemplate](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) COLLATE Hungarian_CI_AS NOT NULL,
	[HeaderText] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
	[FooterText] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
	[DateCity] [nvarchar](32) COLLATE Hungarian_CI_AS NULL,
	[SubscroberPerson] [nvarchar](32) COLLATE Hungarian_CI_AS NULL,
	[SubscroberTitle] [nvarchar](32) COLLATE Hungarian_CI_AS NULL,
 CONSTRAINT [pDebitLetterTemplate] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]




/****** Object:  Table [dbo].[DebitInterest]    Script Date: 05/14/2015 22:01:07 ******/
CREATE TABLE [dbo].[DebitInterest](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) COLLATE Hungarian_CI_AS NOT NULL,
 CONSTRAINT [pDebitInterest] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]




/****** Object:  Table [dbo].[DebitInterestRate]    Script Date: 05/14/2015 22:01:52 ******/
CREATE TABLE [dbo].[DebitInterestRate](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[DebitInterestId] [int] NOT NULL,
	[FromDate] [datetime] NOT NULL,
	[Rate] [decimal](18, 2) NOT NULL,
 CONSTRAINT [pDebitInterestRate] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[DebitInterestRate]  WITH CHECK ADD  CONSTRAINT [fDebitInterestRateDebitInterest] FOREIGN KEY([DebitInterestId])
REFERENCES [dbo].[DebitInterest] ([Id])
ON UPDATE CASCADE
ON DELETE CASCADE
ALTER TABLE [dbo].[DebitInterestRate] CHECK CONSTRAINT [fDebitInterestRateDebitInterest]




/****** Object:  Table [dbo].[DebitManagementStatus]    Script Date: 05/07/2015 19:09:47 ******/
CREATE TABLE [dbo].[DebitManagementStatus](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) COLLATE Hungarian_CI_AS NOT NULL,
	[StatusColor] [int] NOT NULL,
	[IsStartStatus] [bit] NOT NULL CONSTRAINT [dDebitManagementStatusIsStartStatus]  DEFAULT ((0)),
	[IsNewFile] [bit] NOT NULL CONSTRAINT [dDebitManagementStatusIsNewFile]  DEFAULT ((0)),
	[DebitManagementFile] [int] NULL,
 CONSTRAINT [pDebitManagementStatus] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

INSERT INTO [dbo].[DebitManagementStatus] ([Name], StatusColor, IsStartStatus) VALUES ('Iktatva', -1315861, 'true')



/****** Object:  Table [dbo].[DebitManagementStatusNext]    Script Date: 05/07/2015 19:10:37 ******/
CREATE TABLE [dbo].[DebitManagementStatusNext](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[DebitManagementStatusId] [int] NOT NULL,
	[StatusNext] [int] NOT NULL,
 CONSTRAINT [pDebitManagementStatusNext] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[DebitManagementStatusNext]  WITH CHECK ADD  CONSTRAINT [fDebitManagementStatusNextDebitManagementStatus] FOREIGN KEY([DebitManagementStatusId])
REFERENCES [dbo].[DebitManagementStatus] ([Id])
ON UPDATE CASCADE
ON DELETE CASCADE
ALTER TABLE [dbo].[DebitManagementStatusNext] CHECK CONSTRAINT [fDebitManagementStatusNextDebitManagementStatus]





/****** Object:  Table [dbo].[DebitManagmentLetterForm]    Script Date: 16/11/2014 16:19:55 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[DebitManagmentLetterForm](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
    [Body] [nvarchar] (max) NULL,
 CONSTRAINT [pDebitManagmentLetterForm] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]




/****** Object:  Table [dbo].[DebitManagementFile]    Script Date: 16/11/2014 16:19:55 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[DebitManagementFile](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AvatarId] [int] NULL,
	[Name] [nvarchar](80) NOT NULL,
	[IsArchive] [bit] NOT NULL CONSTRAINT [dDebitManagementFileIsArchive]  DEFAULT ((0)),
	[IsSuspended] [bit] NOT NULL CONSTRAINT [dDebitManagementFileIsSuspended]  DEFAULT ((0)),
    [VoucherSign] [nvarchar] (8) NOT NULL,
    [CurrentCounter] [int] NOT NULL,
	[ExtraDataCategoryId] [int] NULL,
 CONSTRAINT [pDebitManagementFile] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[DebitManagementFile]  WITH CHECK ADD  CONSTRAINT [fDebitManagementFileAvatar] FOREIGN KEY([AvatarId])
REFERENCES [dbo].[Avatar] ([Id])
ALTER TABLE [dbo].[DebitManagementFile] CHECK CONSTRAINT [fDebitManagementFileAvatar]

ALTER TABLE [dbo].[DebitManagementFile]  WITH CHECK ADD  CONSTRAINT [fDebitManagementFileExtraDataCategory] FOREIGN KEY([ExtraDataCategoryId])
REFERENCES [dbo].[ExtraDataCategory] ([Id])
ALTER TABLE [dbo].[DebitManagementFile] CHECK CONSTRAINT [fDebitManagementFileExtraDataCategory]


/****** Object:  Table [dbo].[DebitManagement]    Script Date: 16/11/2014 16:19:55 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[DebitManagement](
	[Id] [int] IDENTITY(1,1) NOT NULL,
    [timestamp] [timestamp] NOT NULL,
    [AvatarId] [int] NULL,
    [DebitManagementFileId] int NOT NULL,
    [TypeId] [int] NOT NULL,
    [PartnerId] [int] NOT NULL,
    [Identifier] [nvarchar] (32) NOT NULL,
    [Ordinalnumber] [int] NOT NULL,
	[Name] [nvarchar](80) NOT NULL,
    [DebitAmount] [money] NOT NULL,
    [PaymentDeadline] [datetime] NOT NULL,
	[IsArrenged] [bit] NOT NULL CONSTRAINT [dDebitManagementIsArrenged]  DEFAULT ((0)),
	[IsClosed] [bit] NOT NULL CONSTRAINT [dDebitManagementIsClosed]  DEFAULT ((0)),
	[ContoUserId] [int] NULL,
	[DefaultSmsNumber] [nvarchar](128) NULL,
	[DefaultEmailAddress] [nvarchar](128) NULL,
	[IsFixInterest] [bit] NOT NULL CONSTRAINT [dDebitManagement_IsFixInterest]  DEFAULT ((0)),
	[InterestRate] [decimal](18, 2) NULL,
	[DebitInterestId] [int] NULL,
	[LastInterestDate] [datetime] NULL,
	[ProjectId] [int] NULL,
	[Note] [nvarchar](max) COLLATE Hungarian_CI_AS NULL,
 CONSTRAINT [pDebitManagement] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[DebitManagement]  WITH CHECK ADD  CONSTRAINT [fDebitManagementAvatar] FOREIGN KEY([AvatarId])
REFERENCES [dbo].[Avatar] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[DebitManagement] CHECK CONSTRAINT [fDebitManagementAvatar]

ALTER TABLE [dbo].[DebitManagement]  WITH CHECK ADD  CONSTRAINT [fDebitManagementContoUser] FOREIGN KEY([ContoUserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[DebitManagement] CHECK CONSTRAINT [fDebitManagementContoUser]

ALTER TABLE [dbo].[DebitManagement]  WITH CHECK ADD  CONSTRAINT [fDebitManagementDebitInterest] FOREIGN KEY([DebitInterestId])
REFERENCES [dbo].[DebitInterest] ([Id])
ALTER TABLE [dbo].[DebitManagement] CHECK CONSTRAINT [fDebitManagementDebitInterest]

ALTER TABLE [dbo].[DebitManagement]  WITH CHECK ADD  CONSTRAINT [fDebitManagementDebitManagementFile] FOREIGN KEY([DebitManagementFileId])
REFERENCES [dbo].[DebitManagementFile] ([Id])
ALTER TABLE [dbo].[DebitManagement] CHECK CONSTRAINT [fDebitManagementDebitManagementFile]

ALTER TABLE [dbo].[DebitManagement]  WITH CHECK ADD  CONSTRAINT [fDebitManagementDebitPartner] FOREIGN KEY([PartnerId])
REFERENCES [dbo].[Partner] ([Id])
ALTER TABLE [dbo].[DebitManagement] CHECK CONSTRAINT [fDebitManagementDebitPartner]

ALTER TABLE [dbo].[DebitManagement]  WITH CHECK ADD  CONSTRAINT [FK_DebitManagement_DebitManagement] FOREIGN KEY([Id])
REFERENCES [dbo].[DebitManagement] ([Id])
ALTER TABLE [dbo].[DebitManagement] CHECK CONSTRAINT [FK_DebitManagement_DebitManagement]

ALTER TABLE [dbo].[DebitManagement]  WITH CHECK ADD  CONSTRAINT [FK_DebitManagement_Project] FOREIGN KEY([ProjectId])
REFERENCES [dbo].[Project] ([Id])
ALTER TABLE [dbo].[DebitManagement] CHECK CONSTRAINT [FK_DebitManagement_Project]



/****** Object:  Table [dbo].[DebitManagementStatusProcess]    Script Date: 05/10/2015 11:36:44 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[DebitManagementStatusProcess](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[DebitManagementId] [int] NOT NULL,
	[StatusDate] [datetime] NOT NULL,
	[DebitManagementStatusId] [int] NOT NULL,
	[OldFileId] [int] NULL,
	[OldStatus] [int] NULL,
	[UserId] [int] NOT NULL,
 CONSTRAINT [pDebitManagementStatusProcess] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[DebitManagementStatusProcess]  WITH CHECK ADD  CONSTRAINT [fDebitManagementStatusProcessDebitManagement] FOREIGN KEY([DebitManagementId])
REFERENCES [dbo].[DebitManagement] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[DebitManagementStatusProcess] CHECK CONSTRAINT [fDebitManagementStatusProcessDebitManagement]

ALTER TABLE [dbo].[DebitManagementStatusProcess]  WITH CHECK ADD  CONSTRAINT [fDebitManagementStatusProcessDebitManagementStatus] FOREIGN KEY([DebitManagementStatusId])
REFERENCES [dbo].[DebitManagementStatus] ([Id])
ALTER TABLE [dbo].[DebitManagementStatusProcess] CHECK CONSTRAINT [fDebitManagementStatusProcessDebitManagementStatus]




/****** Object:  Table [dbo].[DebitManagementEvent]    Script Date: 16/11/2014 16:19:55 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[DebitManagementEvent](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[DebitManagementId] [int] NOT NULL,
--	[DebitManagmentEventTodoId] [int] NULL,
	[Reference] [nvarchar](32) NOT NULL,
	[Name] [nvarchar](80) NOT NULL,
	[Description] [nvarchar](max) NOT NULL CONSTRAINT [dDebitManagementEventIsClosed]  DEFAULT ((0)),
	[StornoDescription] [nvarchar](max) NULL,
	[EventDate] [datetime] NOT NULL,
	[PaymentDeadline] [datetime] NOT NULL,
	[TypeId] [int] NOT NULL CONSTRAINT [dDebitManagementEventIsDeleted]  DEFAULT ((0)),
	[IsSms] [bit] NOT NULL CONSTRAINT [dDebitManagementEventIsSms]  DEFAULT ((0)),
	[IsEmail] [bit] NOT NULL CONSTRAINT [dDebitManagementEventIsEmail]  DEFAULT ((0)),
	[IsLetter] [bit] NOT NULL CONSTRAINT [dDebitManagementEventIsLetter]  DEFAULT ((0)),
	[IsAllowGroupEmail] [bit] NOT NULL CONSTRAINT [dDebitManagementEventIsAllowGroupEmail]  DEFAULT ((1)),
 CONSTRAINT [pDebitManagementEvent] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[DebitManagementEvent]  WITH CHECK ADD  CONSTRAINT [fDebitManagementEventDebitManagement] FOREIGN KEY([DebitManagementId])
REFERENCES [dbo].[DebitManagement] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[DebitManagementEvent] CHECK CONSTRAINT [fDebitManagementEventDebitManagement]

--ALTER TABLE [dbo].[DebitManagementEvent]  WITH CHECK ADD  CONSTRAINT [fDebitManagementEventDebitManagmentEventTodo] FOREIGN KEY([DebitManagmentEventTodoId])
--REFERENCES [dbo].[DebitManagmentEventTodo] ([Id])
--ALTER TABLE [dbo].[DebitManagementEvent] CHECK CONSTRAINT [fDebitManagementEventDebitManagmentEventTodo]



/****** Object:  Table [dbo].[DebitManagementInterest]    Script Date: 05/17/2015 09:04:28 ******/
CREATE TABLE [dbo].[DebitManagementInterest](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[DebitManagementId] [int] NOT NULL,
	[Debits] [decimal](18, 2) NOT NULL,
	[DebitsDate] [datetime] NOT NULL,
	[Credits] [decimal](18, 2) NULL,
	[CreditsDate] [datetime] NULL,
 CONSTRAINT [pDebitManagementInterest] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[DebitManagementInterest]  WITH CHECK ADD  CONSTRAINT [fDebitManagementInterestDebitManagement] FOREIGN KEY([DebitManagementId])
REFERENCES [dbo].[DebitManagement] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[DebitManagementInterest] CHECK CONSTRAINT [fDebitManagementInterestDebitManagement]



/****** Object:  Table [dbo].[DebitManagementEventToEmail]    Script Date: 11/19/2014 12:31:32 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[DebitManagementEventToEmail](
	[DebitManagementEventId] [int] NOT NULL,
	[EmailId] [int] NOT NULL,
 CONSTRAINT [pDebitManagementEventEmail] PRIMARY KEY CLUSTERED 
(
	[DebitManagementEventId] ASC,
	[EmailId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[DebitManagementEventToEmail]  WITH CHECK ADD  CONSTRAINT [fDebitManagementEventEmailDebitManagementEvent] FOREIGN KEY([DebitManagementEventId])
REFERENCES [dbo].[DebitManagementEvent] ([Id])
ALTER TABLE [dbo].[DebitManagementEventToEmail] CHECK CONSTRAINT [fDebitManagementEventEmailDebitManagementEvent]

ALTER TABLE [dbo].[DebitManagementEventToEmail]  WITH CHECK ADD  CONSTRAINT [fDebitManagementEventEmailEmail] FOREIGN KEY([EmailId])
REFERENCES [dbo].[Email] ([Id])
ALTER TABLE [dbo].[DebitManagementEventToEmail] CHECK CONSTRAINT [fDebitManagementEventEmailEmail]




/****** Object:  Table [dbo].[DebitManagementReference]    Script Date: 11/19/2014 12:39:59 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[DebitManagementReference](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[DebitManagementId] [int] NOT NULL,
	[Reference] [nvarchar](32) NULL,
	[Amount] [money] NOT NULL,
	[PaidDeadline] [datetime] NOT NULL,
 CONSTRAINT [pDebitManagementReference] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[DebitManagementReference]  WITH CHECK ADD  CONSTRAINT [fDebitManagementReferenceDebitManagement] FOREIGN KEY([DebitManagementId])
REFERENCES [dbo].[DebitManagement] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[DebitManagementReference] CHECK CONSTRAINT [fDebitManagementReferenceDebitManagement]




/****** Object:  Table [dbo].[DebitManagementAquittance]    Script Date: 16/11/2014 16:19:55 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[DebitManagementAquittance](
	[Id] [int] IDENTITY(1,1) NOT NULL,
    [DebitManagementId] [int] NOT NULL,
	[Name] [nvarchar](80) NULL,
    [PaymentDate] [datetime] NOT NULL,
    [PaidAmount] [money] NOT NULL,
	[DebitManagementReferenceId] [int] NULL,
 CONSTRAINT [pDebitManagementAquittance] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[DebitManagementAquittance]  WITH CHECK ADD  CONSTRAINT [fDebitManagementAquittanceDebitManagement] FOREIGN KEY([DebitManagementId])
REFERENCES [dbo].[DebitManagement] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[DebitManagementAquittance] CHECK CONSTRAINT [fDebitManagementAquittanceDebitManagement]





/****** Object:  Table [dbo].[DebitManagementSettings]    Script Date: 11/17/2014 16:29:56 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[DebitManagementSettings](
	[Id] [int] NOT NULL,
	[EmailChannelId] [int] NOT NULL,
	[SmsChannelId] [int] NOT NULL,
	[ClientNoId] [int] NOT NULL,
	[VoucherFormat] [int] NOT NULL,
	[VoucherDigits] [int] NOT NULL,
	[VoucherSepFirst] [nvarchar](5) NULL,
	[VoucherSepLast] [nvarchar](5) NULL,
    [YearNum] [int] NOT NULL,
	[GsmModemPort] [nvarchar](16) NULL,
	[Logo] [varbinary](max) NULL,
	[HeaderLogo] [varbinary](max) NULL,
	[IsFillStartBrowser] [bit] NOT NULL CONSTRAINT [dDebitManagementSettings_IsFillStartBrowser]  DEFAULT ((0)),
 CONSTRAINT [pDebitManagementSettings] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[DebitManagementAffairEvent]    Script Date: 04/24/2016 08:34:07 ******/
CREATE TABLE [dbo].[DebitManagementAffairEvent](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[DebitManagementId] [int] NOT NULL,
	[EventDate] [datetime] NOT NULL,
	[EventText] [nvarchar](max) COLLATE Hungarian_CI_AS NOT NULL,
 CONSTRAINT [PK_DebitManagementAffairEvent] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[DebitManagementAffairEvent]  WITH CHECK ADD  CONSTRAINT [FK_DebitManagementAffairEvent_DebitManagement] FOREIGN KEY([DebitManagementId])
REFERENCES [dbo].[DebitManagement] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[DebitManagementAffairEvent] CHECK CONSTRAINT [FK_DebitManagementAffairEvent_DebitManagement]




/****** Object:  Table [dbo].[DebitManagementEventTemplate]    Script Date: 09/10/2017 10:00:03 ******/
CREATE TABLE [dbo].[DebitManagementEventTemplate](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](max) NOT NULL,
 CONSTRAINT [PK_DebitManagementEventTemplate] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]





INSERT INTO [dbo].[DebitManagementSettings] (Id, EmailChannelId, SmsChannelId, ClientNoId, VoucherFormat, VoucherDigits, VoucherSepFirst, VoucherSepLast, YearNum) 
       VALUES (1, 0, 0, 0, 4, 6, '-', '/', 2014)



/****** Object:  Table [dbo].[TableType]    Script Date: 08/04/2014 09:55:40 ******/
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (980, 'DebitManagementFile', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (981, 'DebitManagement', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (982, 'DebitManagementEvent', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (983, 'DebitManagementAquittance', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (984, 'DebitInterest', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (985, 'DebitManagmentLetterForm', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (986, 'DebitManagementStatus', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (987, 'DebitManagementStatusNext', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (988, 'DebitManagementEventToEmail', 0, 0)
--INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (989, 'DebitManagementEventToSms', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (990, 'DebitManagementReference', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (991, 'DebitInterestRate', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (992, 'DebitLetterTemplate', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (993, 'DebitManagementStatusProcess', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (994, 'DebitManagementInterest', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (995, 'DebitManagementSettings', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (996, 'DebitManagementAffairEvent', 0, 0)





/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 01/04/2015 21:26:52 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ClicxoftDatabaseRevison]') AND type in (N'U'))
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	CREATE TABLE [dbo].[ClicxoftDatabaseRevison](
		[Revision] [int] NOT NULL,
		[ProductId] [int] NOT NULL,
		[Performed] [datetime] NOT NULL,
	 CONSTRAINT [pClicxoftDatabaseRevison] PRIMARY KEY CLUSTERED 
	(
		[Revision] ASC,
		[ProductId] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1000, 'ClicxoftDatabaseRevison', 0, 0)
END

IF (SELECT [Revision] FROM [ClicxoftDatabaseRevison] WHERE [ProductId] = 5) IS NULL
BEGIN
	INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (502, 5, '2016.04.24')
END