/****** Object:  Table [dbo].[ContractSetting]    Script Date: 02/06/2015 20:28:31 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
CREATE TABLE [dbo].[ContractSetting](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[IsDraftDeletable] [bit] NOT NULL CONSTRAINT [DF_ContarctSetting_IsContractDeleteable]  DEFAULT ((1)),
	[VoucherFormat] [int] NOT NULL,
	[VoucherDigits] [int] NOT NULL,
	[VoucherSepFirst] [nvarchar](5) COLLATE Hungarian_CI_AS NULL,
	[VoucherSepLast] [nvarchar](5) COLLATE Hungarian_CI_AS NULL,
	[YearNum] [int] NOT NULL,
	[GsmModemPort] [nvarchar](16) COLLATE Hungarian_CI_AS NULL,
	[IsLog] [bit] NOT NULL CONSTRAINT [dContarctSetting_IsLog]  DEFAULT ((0)),
	[ClientNoId] [int] NULL,
	[HeaderLogo] [varbinary](max) NULL,
	[HeightLogo] [int] NULL,
	[WidthLogo] [int] NULL,
	[DeadlineDay] [int] NOT NULL CONSTRAINT [dContractSetting_DeadlineDay]  DEFAULT ((30)),
 CONSTRAINT [pContarctSetting] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

SET ANSI_PADDING OFF





/****** Object:  Table [dbo].[ContractTemplate]    Script Date: 01/01/2015 12:02:39 ******/
SET ANSI_NULLS ON

SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractTemplate](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[HeaderText] [nvarchar](max)  NULL,
	[IsHeaderPrint] [bit] NOT NULL CONSTRAINT [dContractTemplate_IsHeaderPrint]  DEFAULT ((0)),
	[IsExtraDataPrint] [bit] NOT NULL CONSTRAINT [DF_ContractTemplate_IsExtraDataPrint]  DEFAULT ((0)),
	[BodyText] [nvarchar](max)  NULL,
	[IsBodyPrint] [bit] NOT NULL CONSTRAINT [dContractTemplate_IsBodyPrint]  DEFAULT ((0)),
	[SignatureText] [nvarchar](max)  NULL,
	[IsSignaturePrint] [bit] NOT NULL CONSTRAINT [dContractTemplate_IsSignaturePrint]  DEFAULT ((0)),
	[FirmRole] [nvarchar](50) COLLATE Hungarian_CI_AS NULL,
	[PartnerRole] [nvarchar](50) COLLATE Hungarian_CI_AS NULL,
	[City] [nvarchar](50) COLLATE Hungarian_CI_AS NULL,
	[PrintingDate] [datetime] NULL,
	[ExtraDataHeader] [nvarchar](50) COLLATE Hungarian_CI_AS NULL,
	[FontType] [int] NULL,
	[FontSize] [int] NULL,
 CONSTRAINT [pContractTemplate] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[ContractUserRight]    Script Date: 01/01/2015 12:05:42 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractUserRight](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[UserId] [int] NOT NULL,
	[RightTypeId] [int] NOT NULL,
 CONSTRAINT [pContractUserRight] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[ContractUserChannel]    Script Date: 01/01/2015 12:06:23 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractUserChannel](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ContractUserRightId] [int] NOT NULL,
	[ChannelId] [int] NOT NULL,
	[Value] [nvarchar](32)  NOT NULL,
 CONSTRAINT [pContractUserChannel] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractUserChannel]  WITH CHECK ADD  CONSTRAINT [fContractUserChannelChannel] FOREIGN KEY([ChannelId])
REFERENCES [dbo].[Channel] ([Id])
ALTER TABLE [dbo].[ContractUserChannel] CHECK CONSTRAINT [fContractUserChannelChannel]

ALTER TABLE [dbo].[ContractUserChannel]  WITH CHECK ADD  CONSTRAINT [fContractUserChannelContractUserRight] FOREIGN KEY([ContractUserRightId])
REFERENCES [dbo].[ContractUserRight] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractUserChannel] CHECK CONSTRAINT [fContractUserChannelContractUserRight]



/****** Object:  Table [dbo].[ContractFile]    Script Date: 01/01/2015 12:07:38 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractFile](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[AvatarId] [int] NULL,
	[Name] [nvarchar](80)  NOT NULL,
	[CurrentCounter] [int] NOT NULL,
	[VoucherSign] [nvarchar](6)  NULL,
	[IsGeneratedVoucher] [bit] NOT NULL CONSTRAINT [dContractFile_IsGeneratedVoucher]  DEFAULT ((0)),
	[IsArchive] [bit] NOT NULL CONSTRAINT [dContractFile_IsArchive]  DEFAULT ((0)),
	[ExtraDataCategoryId] [int] NULL,
	[FinalizedFileId] [int] NULL,
	[ArchiveFileId] [int] NULL,
 CONSTRAINT [pContractFile] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[ContractFile]  WITH CHECK ADD  CONSTRAINT [fContractFileAvatar] FOREIGN KEY([AvatarId])
REFERENCES [dbo].[Avatar] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractFile] CHECK CONSTRAINT [fContractFileAvatar]

ALTER TABLE [dbo].[ContractFile]  WITH CHECK ADD  CONSTRAINT [fContractFileContractFile1] FOREIGN KEY([FinalizedFileId])
REFERENCES [dbo].[ContractFile] ([Id])
ALTER TABLE [dbo].[ContractFile] CHECK CONSTRAINT [fContractFileContractFile1]

ALTER TABLE [dbo].[ContractFile]  WITH CHECK ADD  CONSTRAINT [fContractFileContractFile2] FOREIGN KEY([ArchiveFileId])
REFERENCES [dbo].[ContractFile] ([Id])
ALTER TABLE [dbo].[ContractFile] CHECK CONSTRAINT [fContractFileContractFile2]




/****** Object:  Table [dbo].[Contract]    Script Date: 01/01/2015 12:08:35 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[Contract](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[timestamp] [timestamp] NOT NULL,
	[AvatarId] [int] NULL,
	[ContractFileId] [int] NOT NULL,
	[ContractTemplateId] [int] NULL,
	[OrdinalNumber] [int] NOT NULL,
	[VoucherNum] [nvarchar](32) COLLATE Hungarian_CI_AS NOT NULL,
	[Name] [nvarchar](132) COLLATE Hungarian_CI_AS NOT NULL,
	[VoucherDate] [datetime] NOT NULL,
	[Subject] [nvarchar](50)  COLLATE Hungarian_CI_AS NOT NULL,
	[PartnerId] [int] NULL,
	[ProcessStatus] [int] NOT NULL,
	[DeadLine] [datetime] NULL,
	[Note] [nvarchar](max)  COLLATE Hungarian_CI_AS NULL,
	[FileStoreId] [int] NULL,
	[ResponsibleUser] [int] NOT NULL,
	[ProjectId] [int] NULL,
 CONSTRAINT [pContract] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[Contract]  WITH CHECK ADD  CONSTRAINT [fContractContractFile] FOREIGN KEY([ContractFileId])
REFERENCES [dbo].[ContractFile] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[Contract] CHECK CONSTRAINT [fContractContractFile]

ALTER TABLE [dbo].[Contract]  WITH CHECK ADD  CONSTRAINT [fContractContractTemplate] FOREIGN KEY([ContractTemplateId])
REFERENCES [dbo].[ContractTemplate] ([Id])
ALTER TABLE [dbo].[Contract] CHECK CONSTRAINT [fContractContractTemplate]

ALTER TABLE [dbo].[Contract]  WITH CHECK ADD  CONSTRAINT [fContractPartner] FOREIGN KEY([PartnerId])
REFERENCES [dbo].[Partner] ([Id])
ALTER TABLE [dbo].[Contract] CHECK CONSTRAINT [fContractPartner]

ALTER TABLE [dbo].[Contract]  WITH CHECK ADD  CONSTRAINT [fContractProject] FOREIGN KEY([ProjectId])
REFERENCES [dbo].[Project] ([Id])
ALTER TABLE [dbo].[Contract] CHECK CONSTRAINT [fContractProject]



/****** Object:  Table [dbo].[ContractToContract]    Script Date: 01/12/2015 12:10:59 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractToContract](
	[FromContractId] [int] NOT NULL,
	[ToContractId] [int] NOT NULL,
 CONSTRAINT [pContractToContract] PRIMARY KEY CLUSTERED 
(
	[FromContractId] ASC,
	[ToContractId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractToContract]  WITH CHECK ADD  CONSTRAINT [fContractToContractContractFrom] FOREIGN KEY([FromContractId])
REFERENCES [dbo].[Contract] ([Id])
ALTER TABLE [dbo].[ContractToContract] CHECK CONSTRAINT [fContractToContractContractFrom]

ALTER TABLE [dbo].[ContractToContract]  WITH CHECK ADD  CONSTRAINT [fContractToContractContractTo] FOREIGN KEY([ToContractId])
REFERENCES [dbo].[Contract] ([Id])
ALTER TABLE [dbo].[ContractToContract] CHECK CONSTRAINT [fContractToContractContractTo]



/****** Object:  Table [dbo].[ContractTodo]    Script Date: 01/01/2015 12:09:32 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractTodo](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ContractId] [int] NOT NULL,
	[EventDate] [datetime] NOT NULL,
	[Name] [nvarchar](132)  NOT NULL,
	[DeadLine] [datetime] NULL,
	[Note] [nvarchar](max)  NULL,
	[StornoNote] [nvarchar](max)  NULL,
	[TypeId] [int] NOT NULL,
	[ResponsibleUser] [int] NULL,
 CONSTRAINT [pContractTodo] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractTodo]  WITH CHECK ADD  CONSTRAINT [fContractTodoContoUser] FOREIGN KEY([ResponsibleUser])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[ContractTodo] CHECK CONSTRAINT [fContractTodoContoUser]

ALTER TABLE [dbo].[ContractTodo]  WITH CHECK ADD  CONSTRAINT [fContractTodoContract] FOREIGN KEY([ContractId])
REFERENCES [dbo].[Contract] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractTodo] CHECK CONSTRAINT [fContractTodoContract]



/****** Object:  Table [dbo].[ContractEvent]    Script Date: 01/01/2015 12:10:28 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractEvent](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ContractId] [int] NOT NULL,
	[EventTypeId] [int] NOT NULL,
	[Description] [nvarchar](max)  NOT NULL,
	[EventDate] [datetime] NOT NULL,
	[ProcessStatusId] [int] NOT NULL,
	[IsGenerated] [bit] NOT NULL CONSTRAINT [dContractEvent_IsGenetated]  DEFAULT ((0)),
 CONSTRAINT [pContractEvent] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractEvent]  WITH CHECK ADD  CONSTRAINT [fContractEventContract] FOREIGN KEY([ContractId])
REFERENCES [dbo].[Contract] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractEvent] CHECK CONSTRAINT [fContractEventContract]



/****** Object:  Table [dbo].[ContractBlog]    Script Date: 01/01/2015 12:25:00 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractBlog](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ContactId] [int] NOT NULL,
	[BlogRtf] [nvarchar](max)  NOT NULL,
	[BlogText] [nvarchar](max)  NOT NULL,
	[UserId] [int] NOT NULL,
 CONSTRAINT [pContractBlog] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractBlog]  WITH CHECK ADD  CONSTRAINT [fContractBlogContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[ContractBlog] CHECK CONSTRAINT [fContractBlogContoUser]

ALTER TABLE [dbo].[ContractBlog]  WITH CHECK ADD  CONSTRAINT [fContractBlogContract] FOREIGN KEY([ContactId])
REFERENCES [dbo].[Contract] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractBlog] CHECK CONSTRAINT [fContractBlogContract]



/****** Object:  Table [dbo].[ContractUsers]    Script Date: 01/01/2015 12:26:07 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractUsers](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ContractId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[RightTypeId] [int] NOT NULL CONSTRAINT [dContractUsers_IsReadOnly]  DEFAULT ((0)),
 CONSTRAINT [pContractUsers] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractUsers]  WITH CHECK ADD  CONSTRAINT [fContractUsersContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[ContractUsers] CHECK CONSTRAINT [fContractUsersContoUser]

ALTER TABLE [dbo].[ContractUsers]  WITH CHECK ADD  CONSTRAINT [fContractUsersContract] FOREIGN KEY([ContractId])
REFERENCES [dbo].[Contract] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractUsers] CHECK CONSTRAINT [fContractUsersContract]



/****** Object:  Table [dbo].[ContractKeyWord]    Script Date: 01/01/2015 12:27:03 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractKeyWord](
	[ContractId] [int] NOT NULL,
	[KeyWordId] [int] NOT NULL,
 CONSTRAINT [pContractKeyWord] PRIMARY KEY CLUSTERED 
(
	[ContractId] ASC,
	[KeyWordId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractKeyWord]  WITH CHECK ADD  CONSTRAINT [fContractKeyWordContract] FOREIGN KEY([ContractId])
REFERENCES [dbo].[Contract] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractKeyWord] CHECK CONSTRAINT [fContractKeyWordContract]

ALTER TABLE [dbo].[ContractKeyWord]  WITH CHECK ADD  CONSTRAINT [fContractKeyWordKeyWord] FOREIGN KEY([KeyWordId])
REFERENCES [dbo].[KeyWord] ([Id])
ALTER TABLE [dbo].[ContractKeyWord] CHECK CONSTRAINT [fContractKeyWordKeyWord]



/****** Object:  Table [dbo].[ContractLicensing]    Script Date: 01/01/2015 12:27:51 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractLicensing](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ContractId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[IsLicenced] [bit] NOT NULL CONSTRAINT [dContractLicensing_IsLicenced]  DEFAULT ((0)),
	[LicencingDate] [datetime] NULL,
	[DeadLine] [datetime] NULL,
 CONSTRAINT [pContractLicensing] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractLicensing]  WITH CHECK ADD  CONSTRAINT [fContractLicensingContoUser] FOREIGN KEY([UserId])
REFERENCES [dbo].[ContoUser] ([Id])
ALTER TABLE [dbo].[ContractLicensing] CHECK CONSTRAINT [fContractLicensingContoUser]

ALTER TABLE [dbo].[ContractLicensing]  WITH CHECK ADD  CONSTRAINT [fContractLicensingContract] FOREIGN KEY([ContractId])
REFERENCES [dbo].[Contract] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractLicensing] CHECK CONSTRAINT [fContractLicensingContract]



/****** Object:  Table [dbo].[ContractContact]    Script Date: 01/01/2015 12:28:55 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractContact](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ContractId] [int] NOT NULL,
	[ContactId] [int] NOT NULL,
	[PhoneValue] [nvarchar](16)  NULL,
	[EmailValue] [nvarchar](32)  NULL,
	[MobilValue] [nvarchar](16)  NULL,
 CONSTRAINT [pContractContact] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractContact]  WITH CHECK ADD  CONSTRAINT [fContractContactContact] FOREIGN KEY([ContactId])
REFERENCES [dbo].[Contact] ([Id])
ALTER TABLE [dbo].[ContractContact] CHECK CONSTRAINT [fContractContactContact]

ALTER TABLE [dbo].[ContractContact]  WITH CHECK ADD  CONSTRAINT [fContractContactContract] FOREIGN KEY([ContractId])
REFERENCES [dbo].[Contract] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractContact] CHECK CONSTRAINT [fContractContactContract]



/****** Object:  Table [dbo].[ContractFileInvoiceFile]    Script Date: 01/01/2015 12:29:45 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractFileInvoiceFile](
	[ContractFileId] [int] NOT NULL,
	[TaxYearId] [int] NOT NULL,
	[InvoiceFileId] [int] NOT NULL,
 CONSTRAINT [pContractFileInvoiceFile_1] PRIMARY KEY CLUSTERED 
(
	[ContractFileId] ASC,
	[TaxYearId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractFileInvoiceFile]  WITH CHECK ADD  CONSTRAINT [fContractFileInvoiceFileInvoiceFile] FOREIGN KEY([InvoiceFileId])
REFERENCES [dbo].[InvoiceFile] ([Id])
ALTER TABLE [dbo].[ContractFileInvoiceFile] CHECK CONSTRAINT [fContractFileInvoiceFileInvoiceFile]

ALTER TABLE [dbo].[ContractFileInvoiceFile]  WITH CHECK ADD  CONSTRAINT [fContractFileInvoiceFileTaxYear] FOREIGN KEY([TaxYearId])
REFERENCES [dbo].[TaxYear] ([Id])
ALTER TABLE [dbo].[ContractFileInvoiceFile] CHECK CONSTRAINT [fContractFileInvoiceFileTaxYear]



/****** Object:  Table [dbo].[ContractInvoicing]    Script Date: 01/01/2015 12:30:40 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractInvoicing](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ContractId] [int] NOT NULL,
	[InvoiceCurrencyId] [nchar](3)  NOT NULL,
	[InvoiceHeaderNote] [nvarchar](max)  NULL,
	[InvoiceFooterNote] [nvarchar](max)  NULL,
	[FirstInvoicing] [datetime] NOT NULL,
	[LastInvoicing] [datetime] NULL,
	[PeriodTypeId] [int] NOT NULL,
	[InvoicePartnerId] [int] NOT NULL,
	[RateTypeId] [int] NOT NULL,
	[FulfilmentType] [int] NOT NULL,
	[PaymentId] [int] NOT NULL,
 CONSTRAINT [pContractInvoicing] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractInvoicing]  WITH CHECK ADD  CONSTRAINT [fContractInvoicingContract] FOREIGN KEY([ContractId])
REFERENCES [dbo].[Contract] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractInvoicing] CHECK CONSTRAINT [fContractInvoicingContract]

ALTER TABLE [dbo].[ContractInvoicing]  WITH CHECK ADD  CONSTRAINT [fContractInvoicingCurrency] FOREIGN KEY([InvoiceCurrencyId])
REFERENCES [dbo].[Currency] ([Id])
ALTER TABLE [dbo].[ContractInvoicing] CHECK CONSTRAINT [fContractInvoicingCurrency]

ALTER TABLE [dbo].[ContractInvoicing]  WITH CHECK ADD  CONSTRAINT [fContractInvoicingPayment] FOREIGN KEY([PaymentId])
REFERENCES [dbo].[Payment] ([Id])
ALTER TABLE [dbo].[ContractInvoicing] CHECK CONSTRAINT [fContractInvoicingPayment]



/****** Object:  Table [dbo].[ContractInvoicingItem]    Script Date: 01/01/2015 12:31:29 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
CREATE TABLE [dbo].[ContractInvoicingItem](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ContractInvoicingId] [int] NOT NULL,
	[CN] [varchar](15)  NULL,
	[Description] [nvarchar](80)  NULL,
	[TaxId] [int] NULL,
	[Quantity] [decimal](18, 6) NULL,
	[Measure] [nvarchar](12)  NULL,
	[UnitPrice] [decimal](18, 8) NULL,
	[Note] [nvarchar](max)  NULL,
 CONSTRAINT [pContractInvoicingItem] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

SET ANSI_PADDING OFF

ALTER TABLE [dbo].[ContractInvoicingItem]  WITH CHECK ADD  CONSTRAINT [fContractInvoicingItemContractInvoicing] FOREIGN KEY([ContractInvoicingId])
REFERENCES [dbo].[ContractInvoicing] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractInvoicingItem] CHECK CONSTRAINT [fContractInvoicingItemContractInvoicing]



/****** Object:  Table [dbo].[ContractInvoicingEvent]    Script Date: 01/01/2015 12:59:37 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractInvoicingEvent](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ContractId] [int] NOT NULL,
	[InvoiceId] [int] NULL,
	[DueDate] [datetime] NOT NULL,
 CONSTRAINT [pContractInvoicingEvent] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractInvoicingEvent]  WITH CHECK ADD  CONSTRAINT [fContractInvoicingEventContract] FOREIGN KEY([ContractId])
REFERENCES [dbo].[Contract] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractInvoicingEvent] CHECK CONSTRAINT [fContractInvoicingEventContract]

ALTER TABLE [dbo].[ContractInvoicingEvent]  WITH CHECK ADD  CONSTRAINT [fContractInvoicingEventInvoice] FOREIGN KEY([InvoiceId])
REFERENCES [dbo].[Invoice] ([Id])
ALTER TABLE [dbo].[ContractInvoicingEvent] CHECK CONSTRAINT [fContractInvoicingEventInvoice]




/****** Object:  Table [dbo].[ContractLog]    Script Date: 01/21/2015 08:49:44 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ContractLog](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ContractId] [int] NOT NULL,
	[UserId] [int] NOT NULL,
	[LogDate] [datetime] NOT NULL,
	[LogText] [nvarchar](max) COLLATE Hungarian_CI_AS NOT NULL,
 CONSTRAINT [pContractLog] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[ContractLog]  WITH CHECK ADD  CONSTRAINT [fContractLogContract] FOREIGN KEY([ContractId])
REFERENCES [dbo].[Contract] ([Id])
ON DELETE CASCADE
ALTER TABLE [dbo].[ContractLog] CHECK CONSTRAINT [fContractLogContract]





/****** Object:  Table [dbo].[TableType]    Script Date: 05/01/2014 09:55:40 ******/
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (830, 'ContractFile', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (831, 'Contract', 1, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (832, 'ContractTodo', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (833, 'ContractTemplate', 0, 0)
--INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (834, 'ContractEmailTemplate', 0, 0)
--INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (835, 'ContractSmsTemplate', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (836, 'ContractEvent', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (837, 'ContractBlog', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (838, 'ContractUsers', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (839, 'ContractKeyWord', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (840, 'ContractLicensing', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (842, 'ContractSetting', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (843, 'ContractInvoicing', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (844, 'ContractInvoicingItem', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (845, 'ContractInvoicingEvent', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (846, 'ContractUserRight', 0, 0)
--INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (847, 'ContractSms', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (848, 'ContractContact', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (849, 'ContractFileInvoiceFile', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (850, 'ContractUserChannel', 0, 0)
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (851, 'ContractLog', 0, 0)




/****** Szerzds belltsok funkcitr felvtele ******/
INSERT INTO [dbo].[FuncSpace] ([Name], Description, Allowed, TypeId) VALUES ('Clicxoft.Contract.Settings', 'Szerzds program belltsok', 'True', 1)
INSERT INTO [dbo].[FuncSpace] ([Name], Description, Allowed, TypeId) VALUES ('Clicxoft.Contract.Datamining', 'Szerzds adatbnyszat', 'True', 1)
INSERT INTO [dbo].[FuncSpace] ([Name], Description, Allowed, TypeId) VALUES ('Clicxoft.Contract.Relation', 'Szerzds kapcsolatok', 'True', 1)



/****** Object:  Table [dbo].[ClicxoftDatabaseRevison]    Script Date: 01/04/2015 21:26:52 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ClicxoftDatabaseRevison]') AND type in (N'U'))
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	CREATE TABLE [dbo].[ClicxoftDatabaseRevison](
		[Revision] [int] NOT NULL,
		[ProductId] [int] NOT NULL,
		[Performed] [datetime] NOT NULL,
	 CONSTRAINT [pClicxoftDatabaseRevison] PRIMARY KEY CLUSTERED 
	(
		[Revision] ASC,
		[ProductId] ASC
	)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]
INSERT INTO [dbo].[TableType] (Id, [Name], IsAvatarOwner, IsFinanceLinkOwner) VALUES (1000, 'ClicxoftDatabaseRevison', 0, 0)
END

IF (SELECT [Revision] FROM [ClicxoftDatabaseRevison] WHERE [ProductId] = 6) IS NULL
BEGIN
	INSERT INTO [dbo].[ClicxoftDatabaseRevison] ([Revision], [ProductId], [Performed]) VALUES (602, 6, '2016.01.01')
END
